/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.google.common.collect.ImmutableMap;
import com.yahoo.data.access.Type;
import com.yahoo.data.access.slime.SlimeAdapter;
import com.yahoo.prelude.ConfigurationException;
import com.yahoo.prelude.fastsearch.DocsumDefinition;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.slime.BinaryFormat;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class DocsumDefinitionSet {
    public static final int SLIME_MAGIC_ID = 0x55555555;
    private static final Logger log = Logger.getLogger(DocsumDefinitionSet.class.getName());
    private final Map<String, DocsumDefinition> definitionsByName;

    public DocsumDefinitionSet(DocumentdbInfoConfig.Documentdb config) {
        this(DocsumDefinitionSet.toDocsums(config));
    }

    public DocsumDefinitionSet(Collection<DocsumDefinition> docsumDefinitions) {
        this.definitionsByName = ImmutableMap.copyOf(docsumDefinitions.stream().collect(Collectors.toMap(DocsumDefinition::getName, p -> p)));
    }

    public DocsumDefinition getDocsum(String summaryClass) {
        DocsumDefinition ds = this.definitionsByName.get(summaryClass);
        if (ds == null) {
            ds = this.definitionsByName.get("default");
        }
        if (ds == null) {
            throw new ConfigurationException("Fetched hit with summary class " + summaryClass + ", but this summary class is not in current summary config (" + this.toString() + ") (that is, you asked for something unknown, and no default was found)");
        }
        return ds;
    }

    public final String lazyDecode(String summaryClass, byte[] data, FastHit hit) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        long docsumClassId = buffer.getInt();
        if (docsumClassId != 0x55555555L) {
            throw new IllegalArgumentException("Only expecting SchemaLess docsums - summary class:" + summaryClass + " hit:" + hit);
        }
        DocsumDefinition docsumDefinition = this.getDocsum(summaryClass);
        Slime value = BinaryFormat.decode((byte[])buffer.array(), (int)(buffer.arrayOffset() + buffer.position()), (int)buffer.remaining());
        SlimeAdapter docsum = new SlimeAdapter((Inspector)value.get());
        if (docsum.type() != Type.OBJECT) {
            return "Hit " + hit + " failed: " + docsum.asString();
        }
        hit.addSummary(docsumDefinition, (com.yahoo.data.access.Inspector)docsum);
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, DocsumDefinition> e : this.definitionsByName.entrySet()) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append("[").append(e.getKey()).append(",").append(e.getValue().getName()).append("]");
        }
        return sb.toString();
    }

    public int size() {
        return this.definitionsByName.size();
    }

    private static Collection<DocsumDefinition> toDocsums(DocumentdbInfoConfig.Documentdb config) {
        ArrayList<DocsumDefinition> docsums = new ArrayList<DocsumDefinition>();
        for (int i = 0; i < config.summaryclass().size(); ++i) {
            docsums.add(new DocsumDefinition(config.summaryclass(i)));
        }
        if (docsums.isEmpty()) {
            log.warning("No summary classes found in DocumentdbInfoConfig.Documentdb");
        }
        return docsums;
    }
}

