/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude;

import com.yahoo.prelude.Index;
import com.yahoo.text.Lowercase;
import java.util.HashMap;
import java.util.Map;

public class SearchDefinition {
    private String name;
    private Map<String, Index> indices = new HashMap<String, Index>();
    private Map<String, Index> lowerCase = new HashMap<String, Index>();
    private String defaultPosition;

    public SearchDefinition(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultPosition() {
        return this.defaultPosition;
    }

    public void addIndex(Index index) {
        this.indices.put(index.getName(), index);
        this.lowerCase.put(Lowercase.toLowerCase((String)index.getName()), index);
        if (index.isDefaultPosition()) {
            this.defaultPosition = index.getName();
        }
    }

    public void addAlias(String alias, String indexName) {
        Index old = this.indices.get(alias);
        if (old != null) {
            if (old.getName().equals(indexName)) {
                return;
            }
            throw new IllegalArgumentException("Tried adding the alias '" + alias + "' for the index name '" + indexName + "' when the name '" + alias + "' already maps to '" + old.getName() + "'");
        }
        Index index = this.indices.get(indexName);
        if (index == null) {
            throw new IllegalArgumentException("Failed adding alias '" + alias + "' for the index name '" + indexName + "' as there is no index with that name available.");
        }
        this.indices.put(alias, index);
        index.addAlias(alias);
        String lca = Lowercase.toLowerCase((String)alias);
        if (this.lowerCase.get(lca) == null) {
            this.lowerCase.put(lca, index);
        }
    }

    public Index getIndex(String name) {
        return this.indices.get(name);
    }

    public Index getIndexByLowerCase(String name) {
        return this.lowerCase.get(name);
    }

    public Map<String, Index> indices() {
        return this.indices;
    }

    public Index getOrCreateIndex(String name) {
        Index idx = this.getIndex(name);
        if (idx != null) {
            return idx;
        }
        idx = new Index(name);
        this.addIndex(idx);
        return idx;
    }

    public void addCommand(String indexName, String commandString) {
        Index index = this.getOrCreateIndex(indexName);
        index.addCommand(commandString);
        if (index.isDefaultPosition()) {
            this.defaultPosition = index.getName();
        }
    }
}

