/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.compiled;

import com.yahoo.search.query.profile.DimensionValues;
import com.yahoo.search.query.profile.types.QueryProfileType;
import java.util.Objects;
import java.util.Optional;

public class ValueWithSource {
    private final Object value;
    private final String source;
    private final boolean isUnoverridable;
    private final boolean isQueryProfile;
    private final QueryProfileType type;
    private final DimensionValues variant;

    public ValueWithSource(Object value, String source, boolean isUnoverridable, boolean isQueryProfile, QueryProfileType type, DimensionValues variant) {
        this.value = value;
        this.source = source;
        this.isUnoverridable = isUnoverridable;
        this.isQueryProfile = isQueryProfile;
        this.type = type;
        this.variant = variant;
    }

    public Object value() {
        return this.value;
    }

    public String source() {
        return this.source;
    }

    public boolean isUnoverridable() {
        return this.isUnoverridable;
    }

    public boolean isQueryProfile() {
        return this.isQueryProfile;
    }

    public QueryProfileType queryProfileType() {
        return this.type;
    }

    public ValueWithSource withValue(Object value) {
        return new ValueWithSource(value, this.source, this.isUnoverridable, this.isQueryProfile, this.type, this.variant);
    }

    public Optional<DimensionValues> variant() {
        return Optional.ofNullable(this.variant);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.isUnoverridable, this.type});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueWithSource)) {
            return false;
        }
        ValueWithSource other = (ValueWithSource)o;
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.isUnoverridable, other.isUnoverridable)) {
            return false;
        }
        return Objects.equals((Object)this.type, (Object)other.type);
    }

    public String toString() {
        return this.value + " (from query profile '" + this.source + "'" + (String)(this.variant != null ? " variant " + this.variant : "") + ")";
    }
}

