/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import org.apache.commons.math3.distribution.TDistribution;

public class TopKEstimator {
    private final TDistribution studentT;
    private final double defaultP;
    private final boolean estimate;
    private final double skewFactor;

    private static boolean needEstimate(double p) {
        return 0.0 < p && p < 1.0;
    }

    TopKEstimator(double freedom, double defaultProbability) {
        this(freedom, defaultProbability, 0.0);
    }

    public TopKEstimator(double freedom, double defaultProbability, double skewFactor) {
        this.studentT = new TDistribution(null, freedom);
        this.defaultP = defaultProbability;
        this.estimate = TopKEstimator.needEstimate(this.defaultP);
        this.skewFactor = skewFactor;
    }

    double estimateExactK(double k, double n, double p) {
        double p_max = (1.0 + this.skewFactor) / n;
        n = Math.max(1.0, 1.0 / p_max);
        double variance = k * 1.0 / n * (1.0 - 1.0 / n);
        double p_inverse = 1.0 - (1.0 - p) / n;
        return k / n + this.studentT.inverseCumulativeProbability(p_inverse) * Math.sqrt(variance);
    }

    double estimateExactK(double k, double n) {
        return this.estimateExactK(k, n, this.defaultP);
    }

    public int estimateK(int k, int n) {
        return this.estimate && n > 1 ? Math.min(k, (int)Math.ceil(this.estimateExactK(k, n, this.defaultP))) : k;
    }

    public int estimateK(int k, int n, double p) {
        return TopKEstimator.needEstimate(p) && n > 1 ? Math.min(k, (int)Math.ceil(this.estimateExactK(k, n, p))) : k;
    }
}

