/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.search.grouping.request.BucketValue;
import com.yahoo.search.grouping.request.FunctionNode;
import com.yahoo.search.grouping.request.GroupingExpression;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class PredefinedFunction
extends FunctionNode {
    protected PredefinedFunction(String label, Integer level, GroupingExpression exp, List<? extends BucketValue> args) {
        super("predefined", label, level, PredefinedFunction.asList(exp, args));
        Iterator<? extends BucketValue> it = args.iterator();
        BucketValue prev = it.next();
        while (it.hasNext()) {
            BucketValue arg = it.next();
            if (prev.compareTo(arg) >= 0) {
                throw new IllegalArgumentException("Buckets must be monotonically increasing, got " + prev + " before " + arg + ".");
            }
            prev = arg;
        }
    }

    public int getNumBuckets() {
        return this.getNumArgs() - 1;
    }

    public BucketValue getBucket(int i) {
        return (BucketValue)this.getArg(i + 1);
    }

    private static List<GroupingExpression> asList(GroupingExpression exp, List<? extends BucketValue> args) {
        LinkedList<GroupingExpression> ret = new LinkedList<GroupingExpression>();
        ret.add(exp);
        ret.addAll(args);
        return ret;
    }
}

