/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ClusterInfoConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.ComponentId;
import com.yahoo.compress.Compressor;
import com.yahoo.container.handler.VipStatus;
import com.yahoo.jdisc.Metric;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.cluster.ClusterMonitor;
import com.yahoo.search.dispatch.FillInvoker;
import com.yahoo.search.dispatch.InvokerFactory;
import com.yahoo.search.dispatch.LoadBalancer;
import com.yahoo.search.dispatch.SearchErrorInvoker;
import com.yahoo.search.dispatch.SearchInvoker;
import com.yahoo.search.dispatch.SearchPath;
import com.yahoo.search.dispatch.rpc.RpcInvokerFactory;
import com.yahoo.search.dispatch.rpc.RpcPingFactory;
import com.yahoo.search.dispatch.rpc.RpcResourcePool;
import com.yahoo.search.dispatch.searchcluster.Group;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.dispatch.searchcluster.SearchCluster;
import com.yahoo.search.query.Model;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.FieldType;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.vespa.config.search.DispatchConfig;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;

public class Dispatcher
extends AbstractComponent {
    public static final String DISPATCH = "dispatch";
    private static final String INTERNAL = "internal";
    private static final String PROTOBUF = "protobuf";
    private static final String TOP_K_PROBABILITY = "topKProbability";
    private static final String INTERNAL_METRIC = "dispatch_internal";
    private static final int MAX_GROUP_SELECTION_ATTEMPTS = 3;
    public static final CompoundName dispatchProtobuf = CompoundName.fromComponents((String[])new String[]{"dispatch", "protobuf"});
    public static final CompoundName topKProbability = CompoundName.fromComponents((String[])new String[]{"dispatch", "topKProbability"});
    private final SearchCluster searchCluster;
    private final ClusterMonitor clusterMonitor;
    private final LoadBalancer loadBalancer;
    private final InvokerFactory invokerFactory;
    private final Metric metric;
    private final Metric.Context metricContext;
    private final int maxHitsPerNode;
    private static final QueryProfileType argumentType = new QueryProfileType("dispatch");

    public static QueryProfileType getArgumentType() {
        return argumentType;
    }

    @Inject
    public Dispatcher(RpcResourcePool resourcePool, ComponentId clusterId, DispatchConfig dispatchConfig, ClusterInfoConfig clusterInfoConfig, VipStatus vipStatus, Metric metric) {
        this(resourcePool, new SearchCluster(clusterId.stringValue(), dispatchConfig, clusterInfoConfig.nodeCount(), vipStatus, new RpcPingFactory(resourcePool)), dispatchConfig, metric);
    }

    private Dispatcher(RpcResourcePool resourcePool, SearchCluster searchCluster, DispatchConfig dispatchConfig, Metric metric) {
        this(new ClusterMonitor<Node>(searchCluster, true), searchCluster, dispatchConfig, new RpcInvokerFactory(resourcePool, searchCluster), metric);
    }

    protected Dispatcher(ClusterMonitor clusterMonitor, SearchCluster searchCluster, final DispatchConfig dispatchConfig, InvokerFactory invokerFactory, Metric metric) {
        if (dispatchConfig.useMultilevelDispatch()) {
            throw new IllegalArgumentException(searchCluster + " is configured with multilevel dispatch, but this is not supported");
        }
        this.searchCluster = searchCluster;
        this.clusterMonitor = clusterMonitor;
        this.loadBalancer = new LoadBalancer(searchCluster, dispatchConfig.distributionPolicy() == DispatchConfig.DistributionPolicy.ROUNDROBIN);
        this.invokerFactory = invokerFactory;
        this.metric = metric;
        this.metricContext = metric.createContext(null);
        this.maxHitsPerNode = dispatchConfig.maxHitsPerNode();
        searchCluster.addMonitoring(clusterMonitor);
        Thread warmup = new Thread(new Runnable(){

            @Override
            public void run() {
                Dispatcher.warmup(dispatchConfig.warmuptime());
            }
        });
        warmup.start();
        try {
            while (!searchCluster.hasInformationAboutAllNodes()) {
                Thread.sleep(1L);
            }
            warmup.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        searchCluster.pingIterationCompleted();
    }

    private static long warmup(double seconds) {
        return new Compressor().warmup(seconds);
    }

    public SearchCluster searchCluster() {
        return this.searchCluster;
    }

    public void deconstruct() {
        this.clusterMonitor.shutdown();
        this.invokerFactory.release();
    }

    public FillInvoker getFillInvoker(Result result, VespaBackEndSearcher searcher) {
        return this.invokerFactory.createFillInvoker(searcher, result);
    }

    public SearchInvoker getSearchInvoker(Query query, VespaBackEndSearcher searcher) {
        SearchInvoker invoker = this.getSearchPathInvoker(query, searcher).orElseGet(() -> this.getInternalInvoker(query, searcher));
        if (query.properties().getBoolean(Model.ESTIMATE)) {
            query.setHits(0);
            query.setOffset(0);
        }
        this.metric.add(INTERNAL_METRIC, (Number)1, this.metricContext);
        return invoker;
    }

    private Optional<SearchInvoker> getSearchPathInvoker(Query query, VespaBackEndSearcher searcher) {
        String searchPath = query.getModel().getSearchPath();
        if (searchPath == null) {
            return Optional.empty();
        }
        try {
            List<Node> nodes = SearchPath.selectNodes(searchPath, this.searchCluster);
            if (nodes.isEmpty()) {
                return Optional.empty();
            }
            query.trace(false, 2, "Dispatching with search path ", searchPath);
            return this.invokerFactory.createSearchInvoker(searcher, query, OptionalInt.empty(), nodes, true, this.maxHitsPerNode);
        }
        catch (SearchPath.InvalidSearchPathException e) {
            return Optional.of(new SearchErrorInvoker(ErrorMessage.createIllegalQuery(e.getMessage())));
        }
    }

    private SearchInvoker getInternalInvoker(Query query, VespaBackEndSearcher searcher) {
        Optional<Group> groupInCluster;
        Optional<Node> directNode = this.searchCluster.localCorpusDispatchTarget();
        if (directNode.isPresent()) {
            Node node = directNode.get();
            query.trace(false, 2, "Dispatching to ", node);
            return this.invokerFactory.createSearchInvoker(searcher, query, OptionalInt.empty(), Arrays.asList(node), true, this.maxHitsPerNode).orElseThrow(() -> new IllegalStateException("Could not dispatch directly to " + node));
        }
        int covered = this.searchCluster.groupsWithSufficientCoverage();
        int groups = this.searchCluster.orderedGroups().size();
        int max = Integer.min(Integer.min(covered + 1, groups), 3);
        Set<Integer> rejected = this.rejectGroupBlockingFeed((List<Group>)this.searchCluster.orderedGroups());
        for (int i = 0; i < max && !(groupInCluster = this.loadBalancer.takeGroup(rejected)).isEmpty(); ++i) {
            Group group = groupInCluster.get();
            boolean acceptIncompleteCoverage = i == max - 1;
            Optional<SearchInvoker> invoker = this.invokerFactory.createSearchInvoker(searcher, query, OptionalInt.of(group.id()), (List<Node>)group.nodes(), acceptIncompleteCoverage, this.maxHitsPerNode);
            if (invoker.isPresent()) {
                query.trace(false, 2, "Dispatching to group ", group.id());
                query.getModel().setSearchPath("/" + group.id());
                invoker.get().teardown((success, time) -> this.loadBalancer.releaseGroup(group, (boolean)success, time.longValue()));
                return invoker.get();
            }
            this.loadBalancer.releaseGroup(group, false, 0.0);
            if (rejected == null) {
                rejected = new HashSet<Integer>();
            }
            rejected.add(group.id());
        }
        throw new IllegalStateException("No suitable groups to dispatch query. Rejected: " + rejected);
    }

    private Set<Integer> rejectGroupBlockingFeed(List<Group> groups) {
        if (groups.size() == 1) {
            return null;
        }
        List groupsRejectingFeed = groups.stream().filter(Group::isBlockingWrites).collect(Collectors.toList());
        if (groupsRejectingFeed.size() != 1) {
            return null;
        }
        HashSet<Integer> rejected = new HashSet<Integer>();
        rejected.add(((Group)groupsRejectingFeed.get(0)).id());
        return rejected;
    }

    static {
        argumentType.setStrict(true);
        argumentType.setBuiltin(true);
        argumentType.addField(new FieldDescription(INTERNAL, FieldType.booleanType));
        argumentType.addField(new FieldDescription(PROTOBUF, FieldType.booleanType));
        argumentType.addField(new FieldDescription(TOP_K_PROBABILITY, FieldType.doubleType));
        argumentType.freeze();
    }
}

