/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.query.TermType;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.prelude.semantics.engine.Match;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.TermProduction;
import com.yahoo.protect.Validator;

public class LiteralTermProduction
extends TermProduction {
    private String literal;

    public LiteralTermProduction(String literal) {
        this.setLiteral(literal);
    }

    public LiteralTermProduction(String literal, TermType termType) {
        super(termType);
        this.setLiteral(literal);
    }

    public LiteralTermProduction(String label, String literal, TermType termType) {
        super(label, termType);
        this.setLiteral(literal);
    }

    public void setLiteral(String literal) {
        Validator.ensureNotNull((String)"A produced term", (Object)literal);
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    @Override
    public void produce(RuleEvaluation e, int offset) {
        WordItem newItem = new WordItem(this.literal, this.getLabel());
        if (this.replacing) {
            Match matched = e.getNonreferencedMatch(0);
            this.insertMatch(e, matched, newItem, offset);
        } else {
            newItem.setWeight(this.getWeight());
            if (e.getTraceLevel() >= 6) {
                e.trace(6, "Adding '" + newItem + "'");
            }
            e.addItem(newItem, this.getTermType());
        }
    }

    @Override
    public String toInnerTermString() {
        return this.getLabelString() + this.literal;
    }
}

