/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.google.common.annotations.Beta;
import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.SimpleTaggableItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.nio.ByteBuffer;

@Beta
public class NearestNeighborItem
extends SimpleTaggableItem {
    private int targetNumHits = 0;
    private int hnswExploreAdditionalHits = 0;
    private boolean approximate = true;
    private String field;
    private String queryTensorName;

    public NearestNeighborItem(String fieldName, String queryTensorName) {
        this.field = fieldName;
        this.queryTensorName = queryTensorName;
    }

    public int getTargetNumHits() {
        return this.targetNumHits;
    }

    public String getIndexName() {
        return this.field;
    }

    public int getHnswExploreAdditionalHits() {
        return this.hnswExploreAdditionalHits;
    }

    public boolean getAllowApproximate() {
        return this.approximate;
    }

    public String getQueryTensorName() {
        return this.queryTensorName;
    }

    public void setTargetNumHits(int target) {
        this.targetNumHits = target;
    }

    public void setHnswExploreAdditionalHits(int num) {
        this.hnswExploreAdditionalHits = num;
    }

    public void setAllowApproximate(boolean value) {
        this.approximate = value;
    }

    @Override
    public void setIndexName(String index) {
        this.field = index;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.NEAREST_NEIGHBOR;
    }

    @Override
    public String getName() {
        return "NEAREST_NEIGHBOR";
    }

    @Override
    public int getTermCount() {
        return 1;
    }

    @Override
    public int encode(ByteBuffer buffer) {
        super.encodeThis(buffer);
        NearestNeighborItem.putString(this.field, buffer);
        NearestNeighborItem.putString(this.queryTensorName, buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.targetNumHits, (ByteBuffer)buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)(this.approximate ? 1 : 0), (ByteBuffer)buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.hnswExploreAdditionalHits, (ByteBuffer)buffer);
        return 1;
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        buffer.append("{field=").append(this.field);
        buffer.append(",queryTensorName=").append(this.queryTensorName);
        buffer.append(",hnsw.exploreAdditionalHits=").append(this.hnswExploreAdditionalHits);
        buffer.append(",approximate=").append(this.approximate);
        buffer.append(",targetHits=").append(this.targetNumHits).append("}");
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("field", this.field);
        discloser.addProperty("queryTensorName", this.queryTensorName);
        discloser.addProperty("hnsw.exploreAdditionalHits", this.hnswExploreAdditionalHits);
        discloser.addProperty("approximate", this.approximate);
        discloser.addProperty("targetHits", this.targetNumHits);
    }
}

