/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchchain.model;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.dependencies.Dependencies;
import com.yahoo.component.chain.model.ChainedComponentModel;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.prelude.querytransform.PhrasingSearcher;
import com.yahoo.prelude.searcher.BlendingSearcher;
import com.yahoo.prelude.searcher.FieldCollapsingSearcher;
import com.yahoo.prelude.searcher.JuniperSearcher;
import com.yahoo.prelude.searcher.PosSearcher;
import com.yahoo.prelude.semantics.SemanticSearcher;
import com.yahoo.prelude.statistics.StatisticsSearcher;
import com.yahoo.search.Searcher;
import com.yahoo.search.grouping.GroupingQueryParser;
import com.yahoo.search.searchchain.model.federation.FederationSearcherModel;
import com.yahoo.search.yql.FieldFilter;
import com.yahoo.search.yql.MinimalQueryInserter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class VespaSearchers {
    public static final Collection<ChainedComponentModel> vespaSearcherModels = VespaSearchers.toSearcherModels(PhrasingSearcher.class, FieldCollapsingSearcher.class, MinimalQueryInserter.class, FieldFilter.class, JuniperSearcher.class, BlendingSearcher.class, PosSearcher.class, SemanticSearcher.class, GroupingQueryParser.class);
    public static final Collection<ChainedComponentModel> nativeSearcherModels = new LinkedHashSet<ChainedComponentModel>();

    private static boolean allComponentIdsDifferent(Collection<ChainedComponentModel> vespaSearcherModels, Collection<ChainedComponentModel> nativeSearcherModels) {
        LinkedHashSet<ComponentId> componentIds = new LinkedHashSet<ComponentId>();
        return VespaSearchers.allAdded(vespaSearcherModels, componentIds) && VespaSearchers.allAdded(nativeSearcherModels, componentIds);
    }

    private static FederationSearcherModel federationSearcherModel() {
        return new FederationSearcherModel(new ComponentSpecification("federation"), Dependencies.emptyDependencies(), Collections.emptyList(), true);
    }

    private static boolean allAdded(Collection<ChainedComponentModel> searcherModels, Set<ComponentId> componentIds) {
        for (ChainedComponentModel model : searcherModels) {
            if (componentIds.add(model.getComponentId())) continue;
            return false;
        }
        return true;
    }

    private static Collection<ChainedComponentModel> toSearcherModels(Class<? extends Searcher> ... searchers) {
        ArrayList<ChainedComponentModel> searcherModels = new ArrayList<ChainedComponentModel>();
        for (Class<? extends Searcher> c : searchers) {
            searcherModels.add(new ChainedComponentModel(BundleInstantiationSpecification.getInternalSearcherSpecificationFromStrings((String)c.getName(), null), Dependencies.emptyDependencies()));
        }
        return searcherModels;
    }

    static {
        nativeSearcherModels.add(VespaSearchers.federationSearcherModel());
        nativeSearcherModels.addAll(VespaSearchers.toSearcherModels(StatisticsSearcher.class));
        assert (VespaSearchers.allComponentIdsDifferent(vespaSearcherModels, nativeSearcherModels));
    }
}

