/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.compiled;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.SubstituteString;
import com.yahoo.search.query.profile.compiled.Binding;
import com.yahoo.search.query.profile.compiled.ValueWithSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DimensionalValue<VALUE> {
    private final List<Value<VALUE>> values;

    public DimensionalValue(Value<VALUE> value) {
        this.values = Collections.singletonList(value);
    }

    public DimensionalValue(List<Value<VALUE>> valueVariants) {
        if (valueVariants.size() == 1) {
            this.values = Collections.singletonList(valueVariants.get(0));
        } else {
            this.values = new ArrayList<Value<VALUE>>(valueVariants);
            Collections.sort(this.values);
        }
    }

    public VALUE get(Map<String, String> context) {
        if (context == null) {
            context = Collections.emptyMap();
        }
        for (Value<VALUE> value : this.values) {
            if (!value.matches(context)) continue;
            return value.value();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public String toString() {
        return this.values.toString();
    }

    private static class Value<VALUE>
    implements Comparable<Value> {
        private VALUE value = null;
        private Binding binding;

        public Value(VALUE value, Binding binding) {
            this.value = value;
            this.binding = binding;
        }

        public VALUE value() {
            return this.value;
        }

        public Binding binding() {
            if (this.binding == null) {
                return Binding.nullBinding;
            }
            return this.binding;
        }

        public boolean matches(Map<String, String> context) {
            return this.binding.matches(context);
        }

        @Override
        public int compareTo(Value other) {
            return this.binding.compareTo(other.binding);
        }

        public String toString() {
            return " value '" + this.value + "' for " + this.binding;
        }

        private static class Builder<VALUE> {
            private final VALUE value;
            private Set<DimensionBinding> variants = new HashSet<DimensionBinding>();

            public Builder(VALUE value) {
                this.value = value;
            }

            public void addVariant(DimensionBinding binding) {
                this.variants.add(binding);
            }

            public List<Value<VALUE>> build(Map<CompoundName, com.yahoo.search.query.profile.compiled.DimensionalValue$Builder<VALUE>> entries) {
                if (this.variants.size() == 1) {
                    return Collections.singletonList(new Value<VALUE>(this.substituteIfRelative(this.value, this.variants.iterator().next(), entries), Binding.createFrom(this.variants.iterator().next())));
                }
                ArrayList<Value<VALUE>> values = new ArrayList<Value<VALUE>>(this.variants.size());
                for (DimensionBinding variant : this.variants) {
                    values.add(new Value<VALUE>(this.substituteIfRelative(this.value, variant, entries), Binding.createFrom(variant)));
                }
                return values;
            }

            public Object value() {
                return this.value;
            }

            private VALUE substituteIfRelative(VALUE value, DimensionBinding variant, Map<CompoundName, com.yahoo.search.query.profile.compiled.DimensionalValue$Builder<VALUE>> entries) {
                ValueWithSource valueWithSource;
                SubstituteString substitute;
                if (value instanceof ValueWithSource && ((ValueWithSource)value).value() instanceof SubstituteString && (substitute = (SubstituteString)(valueWithSource = (ValueWithSource)value).value()).hasRelative()) {
                    ArrayList<SubstituteString.Component> resolvedComponents = new ArrayList<SubstituteString.Component>(substitute.components().size());
                    for (SubstituteString.Component component : substitute.components()) {
                        if (component instanceof SubstituteString.RelativePropertyComponent) {
                            SubstituteString.RelativePropertyComponent relativeComponent = (SubstituteString.RelativePropertyComponent)component;
                            com.yahoo.search.query.profile.compiled.DimensionalValue$Builder<VALUE> substituteValues = this.lookupByLocalName(relativeComponent.fieldName(), entries);
                            if (substituteValues == null) {
                                throw new IllegalArgumentException("Could not resolve local substitution '" + relativeComponent.fieldName() + "' in variant " + variant);
                            }
                            ValueWithSource resolved = (ValueWithSource)substituteValues.valueFor(variant);
                            resolvedComponents.add(new SubstituteString.StringComponent(resolved.value().toString()));
                            continue;
                        }
                        resolvedComponents.add(component);
                    }
                    return (VALUE)valueWithSource.withValue(new SubstituteString(resolvedComponents, substitute.stringValue()));
                }
                return value;
            }

            private com.yahoo.search.query.profile.compiled.DimensionalValue$Builder<VALUE> lookupByLocalName(String localName, Map<CompoundName, com.yahoo.search.query.profile.compiled.DimensionalValue$Builder<VALUE>> entries) {
                for (Map.Entry<CompoundName, com.yahoo.search.query.profile.compiled.DimensionalValue$Builder<VALUE>> entry : entries.entrySet()) {
                    if (!entry.getKey().last().equals(localName)) continue;
                    return entry.getValue();
                }
                return null;
            }
        }
    }

    public static class Builder<VALUE> {
        private Map<VALUE, Value.Builder<VALUE>> buildableVariants = new HashMap<VALUE, Value.Builder<VALUE>>();

        public VALUE valueFor(DimensionBinding variantBinding) {
            for (Map.Entry<VALUE, Value.Builder<VALUE>> entry : this.buildableVariants.entrySet()) {
                if (!entry.getValue().variants.contains(variantBinding)) continue;
                return entry.getKey();
            }
            return null;
        }

        public void add(VALUE value, DimensionBinding variantBinding) {
            Value.Builder<VALUE> variant = this.buildableVariants.get(value);
            if (variant == null) {
                variant = new Value.Builder<VALUE>(value);
                this.buildableVariants.put(value, variant);
            }
            variant.addVariant(variantBinding);
        }

        public DimensionalValue<VALUE> build(Map<?, Builder<VALUE>> entries) {
            ArrayList variants = new ArrayList();
            for (Value.Builder buildableVariant : this.buildableVariants.values()) {
                variants.addAll(buildableVariant.build(entries));
            }
            return new DimensionalValue(variants);
        }
    }
}

