/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.compiled;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfile;
import com.yahoo.search.query.profile.types.QueryProfileTypeRegistry;

public class CompiledQueryProfileRegistry
extends ComponentRegistry<CompiledQueryProfile> {
    public static final CompiledQueryProfileRegistry empty = CompiledQueryProfileRegistry.createFrozen();
    private final QueryProfileTypeRegistry typeRegistry;

    public CompiledQueryProfileRegistry() {
        this(QueryProfileTypeRegistry.emptyFrozen());
    }

    public CompiledQueryProfileRegistry(QueryProfileTypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    public void register(CompiledQueryProfile profile) {
        super.register(profile.getId(), (Object)profile);
    }

    public QueryProfileTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public CompiledQueryProfile findQueryProfile(String idString) {
        if (idString == null || idString.isEmpty()) {
            return (CompiledQueryProfile)this.getComponent("default");
        }
        ComponentSpecification id = new ComponentSpecification(idString);
        CompiledQueryProfile profile = (CompiledQueryProfile)this.getComponent(id);
        if (profile != null) {
            return profile;
        }
        return this.findPathParentQueryProfile(new ComponentSpecification(idString));
    }

    private CompiledQueryProfile findPathParentQueryProfile(ComponentSpecification id) {
        CompiledQueryProfile slashedProfile = (CompiledQueryProfile)this.getComponent(new ComponentSpecification(id.getName() + "/", id.getVersionSpecification()));
        if (slashedProfile != null && slashedProfile.getType() != null && slashedProfile.getType().getMatchAsPath()) {
            return slashedProfile;
        }
        int slashIndex = id.getName().lastIndexOf("/");
        if (slashIndex < 1) {
            return null;
        }
        String parentName = id.getName().substring(0, slashIndex);
        if (parentName.equals("")) {
            return null;
        }
        ComponentSpecification parentId = new ComponentSpecification(parentName, id.getVersionSpecification());
        CompiledQueryProfile pathParentProfile = (CompiledQueryProfile)this.getComponent(parentId);
        if (pathParentProfile != null && pathParentProfile.getType() != null && pathParentProfile.getType().getMatchAsPath()) {
            return pathParentProfile;
        }
        return this.findPathParentQueryProfile(parentId);
    }

    private static CompiledQueryProfileRegistry createFrozen() {
        CompiledQueryProfileRegistry registry = new CompiledQueryProfileRegistry();
        registry.freeze();
        return registry;
    }
}

