/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.DimensionValues;
import com.yahoo.search.query.profile.PrefixQueryProfileVisitor;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.compiled.ValueWithSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class AllValuesQueryProfileVisitor
extends PrefixQueryProfileVisitor {
    private Map<String, ValueWithSource> values = new HashMap<String, ValueWithSource>();

    public AllValuesQueryProfileVisitor(CompoundName prefix) {
        super(prefix);
    }

    @Override
    public void onValue(String localName, Object value, DimensionBinding binding, QueryProfile owner, DimensionValues variant) {
        this.putValue(localName, value, owner, variant);
    }

    @Override
    public void onQueryProfileInsidePrefix(QueryProfile profile, DimensionBinding binding, QueryProfile owner, DimensionValues variant) {
        this.putValue("", profile.getValue(), owner, variant);
    }

    private void putValue(String key, Object value, QueryProfile owner, DimensionValues variant) {
        if (value == null) {
            return;
        }
        CompoundName fullName = this.currentPrefix.append(key);
        if (fullName.isEmpty()) {
            return;
        }
        if (this.values.containsKey(fullName.toString())) {
            return;
        }
        this.values.put(fullName.toString(), new ValueWithSource(value, owner == null ? "anonymous" : owner.getSource(), variant));
    }

    public Map<String, Object> values() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, ValueWithSource> entry : this.values.entrySet()) {
            values.put(entry.getKey(), entry.getValue().value());
        }
        return values;
    }

    public Map<String, ValueWithSource> valuesWithSource() {
        return Collections.unmodifiableMap(this.values);
    }

    @Override
    public boolean isDone() {
        return false;
    }
}

