/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import org.apache.commons.math3.distribution.TDistribution;

public class TopKEstimator {
    private final TDistribution studentT;
    private final double defaultP;
    private final boolean estimate;

    private static boolean needEstimate(double p) {
        return 0.0 < p && p < 1.0;
    }

    public TopKEstimator(double freedom, double defaultProbability) {
        this.studentT = new TDistribution(null, freedom);
        this.defaultP = defaultProbability;
        this.estimate = TopKEstimator.needEstimate(this.defaultP);
    }

    double estimateExactK(double k, double n, double p) {
        double variance = k * 1.0 / n * (1.0 - 1.0 / n);
        double p_inverse = 1.0 - (1.0 - p) / n;
        return k / n + this.studentT.inverseCumulativeProbability(p_inverse) * Math.sqrt(variance);
    }

    double estimateExactK(double k, double n) {
        return this.estimateExactK(k, n, this.defaultP);
    }

    public int estimateK(int k, int n) {
        return this.estimate && n > 1 ? (int)Math.ceil(this.estimateExactK(k, n, this.defaultP)) : k;
    }

    public int estimateK(int k, int n, double p) {
        return TopKEstimator.needEstimate(p) && n > 1 ? (int)Math.ceil(this.estimateExactK(k, n, p)) : k;
    }
}

