/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchchain;

import com.yahoo.component.chain.Chain;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.search.searchchain.FutureResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AsyncExecution {
    private static final ThreadFactory threadFactory = ThreadFactoryFactory.getThreadFactory((String)"search");
    private static final Executor executorMain = AsyncExecution.createExecutor();
    private final Execution execution;

    private static Executor createExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(100, 8192, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(false), threadFactory);
        executor.prestartAllCoreThreads();
        return executor;
    }

    public AsyncExecution(Chain<? extends Searcher> chain, Execution execution) {
        this(execution.context(), chain);
    }

    public AsyncExecution(Chain<? extends Searcher> chain, Execution.Context context) {
        this(context, chain);
    }

    public AsyncExecution(Execution execution) {
        this.execution = new Execution(execution);
    }

    private AsyncExecution(Execution.Context context, Chain<? extends Searcher> chain) {
        this.execution = new Execution(chain, context);
    }

    public FutureResult search(Query query) {
        return this.getFutureResult(() -> this.execution.search(query), query);
    }

    public FutureResult searchAndFill(Query query) {
        return this.getFutureResult(() -> {
            Result result = this.execution.search(query);
            this.execution.fill(result, query.getPresentation().getSummary());
            return result;
        }, query);
    }

    private static Executor getExecutor() {
        return executorMain;
    }

    public FutureResult fill(Result result, String summaryClass) {
        return this.getFutureResult(() -> {
            this.execution.fill(result, summaryClass);
            return result;
        }, result.getQuery());
    }

    private static <T> Future<T> getFuture(Callable<T> callable) {
        FutureTask<T> future = new FutureTask<T>(callable);
        AsyncExecution.getExecutor().execute(future);
        return future;
    }

    private static Future<Void> runTask(Runnable runnable) {
        return AsyncExecution.getFuture(() -> {
            runnable.run();
            return null;
        });
    }

    private FutureResult getFutureResult(Callable<Result> callable, Query query) {
        FutureResult future = new FutureResult(callable, this.execution, query);
        AsyncExecution.getExecutor().execute(future);
        return future;
    }

    public static List<Result> waitForAll(Collection<FutureResult> tasks, long timeoutMs) {
        ArrayList<FutureResult> workingTasks = new ArrayList<FutureResult>(tasks);
        try {
            AsyncExecution.runTask(() -> {
                for (FutureResult task : workingTasks) {
                    task.get();
                }
            }).get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            // empty catch block
        }
        ArrayList<Result> results = new ArrayList<Result>(tasks.size());
        for (FutureResult atask : workingTasks) {
            Result result = atask.isDone() && !atask.isCancelled() ? atask.get() : new Result(atask.getQuery(), atask.createTimeoutError());
            results.add(result);
        }
        return results;
    }
}

