/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.textserialize.item;

import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TaggableItem;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class ItemContext {
    private final Map<String, Item> itemById = new HashMap<String, Item>();
    private final Map<TaggableItem, Connectivity> connectivityByItem = new IdentityHashMap<TaggableItem, Connectivity>();

    public void setItemId(String id, Item item) {
        this.itemById.put(id, item);
    }

    public void setConnectivity(TaggableItem item, String id, Double strength) {
        this.connectivityByItem.put(item, new Connectivity(id, strength));
    }

    public void connectItems() {
        for (Map.Entry<TaggableItem, Connectivity> entry : this.connectivityByItem.entrySet()) {
            entry.getKey().setConnectivity(this.getItem(entry.getValue().id), entry.getValue().strength);
        }
    }

    private Item getItem(String id) {
        Item item = this.itemById.get(id);
        if (item == null) {
            throw new IllegalArgumentException("No item with id '" + id + "'.");
        }
        return item;
    }

    private class Connectivity {
        final String id;
        final double strength;

        public Connectivity(String id, double strength) {
            this.id = id;
            this.strength = strength;
        }
    }
}

