/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.types;

import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.profile.types.FieldType;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;

public class TensorFieldType
extends FieldType {
    private final TensorType type;

    public TensorFieldType(TensorType type) {
        this.type = type;
    }

    @Override
    public TensorType asTensorType() {
        return this.type;
    }

    @Override
    public Class getValueClass() {
        return Tensor.class;
    }

    @Override
    public String stringValue() {
        return this.type.toString();
    }

    @Override
    public String toString() {
        return "field type " + this.stringValue();
    }

    @Override
    public String toInstanceDescription() {
        return "a tensor";
    }

    @Override
    public Object convertFrom(Object o, QueryProfileRegistry registry) {
        if (o instanceof Tensor) {
            return o;
        }
        if (o instanceof String) {
            return Tensor.from((TensorType)this.type, (String)((String)o));
        }
        return null;
    }

    @Override
    public Object convertFrom(Object o, CompiledQueryProfileRegistry registry) {
        return this.convertFrom(o, (QueryProfileRegistry)null);
    }

    public static TensorFieldType fromTypeString(String s) {
        return new TensorFieldType(TensorType.fromSpec((String)s));
    }
}

