/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.rpc;

import com.yahoo.compress.CompressionType;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.search.dispatch.rpc.RpcFillInvoker;
import java.util.List;
import java.util.Optional;

interface Client {
    public NodeConnection createConnection(String var1, int var2);

    public static class ProtobufResponse {
        private final byte compression;
        private final int uncompressedSize;
        private final byte[] compressedPayload;

        public ProtobufResponse(byte compression, int uncompressedSize, byte[] compressedPayload) {
            this.compression = compression;
            this.uncompressedSize = uncompressedSize;
            this.compressedPayload = compressedPayload;
        }

        public byte compression() {
            return this.compression;
        }

        public int uncompressedSize() {
            return this.uncompressedSize;
        }

        public byte[] compressedPayload() {
            return this.compressedPayload;
        }
    }

    public static interface NodeConnection {
        public void getDocsums(List<FastHit> var1, CompressionType var2, int var3, byte[] var4, RpcFillInvoker.GetDocsumsResponseReceiver var5, double var6);

        public void request(String var1, CompressionType var2, int var3, byte[] var4, ResponseReceiver var5, double var6);

        public void close();
    }

    public static class GetDocsumsResponse {
        private final byte compression;
        private final int uncompressedSize;
        private final byte[] compressedSlimeBytes;
        private final List<FastHit> hitsContext;

        public GetDocsumsResponse(byte compression, int uncompressedSize, byte[] compressedSlimeBytes, List<FastHit> hitsContext) {
            this.compression = compression;
            this.uncompressedSize = uncompressedSize;
            this.compressedSlimeBytes = compressedSlimeBytes;
            this.hitsContext = hitsContext;
        }

        public byte compression() {
            return this.compression;
        }

        public int uncompressedSize() {
            return this.uncompressedSize;
        }

        public byte[] compressedSlimeBytes() {
            return this.compressedSlimeBytes;
        }

        public List<FastHit> hitsContext() {
            return this.hitsContext;
        }
    }

    public static class ResponseOrError<T> {
        final Optional<T> response;
        final Optional<String> error;

        public static <T> ResponseOrError<T> fromResponse(T response) {
            return new ResponseOrError<T>(response);
        }

        public static <T> ResponseOrError<T> fromError(String error) {
            return new ResponseOrError<T>(error);
        }

        ResponseOrError(T response) {
            this.response = Optional.of(response);
            this.error = Optional.empty();
        }

        ResponseOrError(String error) {
            this.response = Optional.empty();
            this.error = Optional.of(error);
        }

        public Optional<T> response() {
            return this.response;
        }

        public Optional<String> error() {
            return this.error;
        }
    }

    public static interface ResponseReceiver {
        public void receive(ResponseOrError<ProtobufResponse> var1);
    }
}

