/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.yahoo.collections.Pair;
import com.yahoo.search.dispatch.searchcluster.Group;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.dispatch.searchcluster.SearchCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SearchPath {
    private final List<NodeSelection> nodes;
    private final Integer group;
    private static final Pattern NODE_WILDCARD = Pattern.compile("^\\*?(?:,|$)");
    private static final Pattern NODE_RANGE = Pattern.compile("^\\[(\\d+),(\\d+)>(?:,|$)");

    public static List<Node> selectNodes(String searchPath, SearchCluster cluster) {
        Optional<SearchPath> sp = SearchPath.fromString(searchPath);
        if (sp.isPresent()) {
            return sp.get().mapToNodes(cluster);
        }
        return Collections.emptyList();
    }

    static Optional<SearchPath> fromString(String path) {
        if (path == null || path.isEmpty()) {
            return Optional.empty();
        }
        if (path.indexOf(59) >= 0) {
            return Optional.empty();
        }
        try {
            SearchPath sp = SearchPath.parseElement(path);
            if (sp.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(sp);
        }
        catch (InvalidSearchPathException | NumberFormatException e) {
            throw new InvalidSearchPathException("Invalid search path: " + path, e);
        }
    }

    private SearchPath(List<NodeSelection> nodes, Integer group) {
        this.nodes = nodes;
        this.group = group;
    }

    private List<Node> mapToNodes(SearchCluster cluster) {
        if (cluster.groups().isEmpty()) {
            return Collections.emptyList();
        }
        Group selectedGroup = this.selectGroup(cluster);
        if (this.nodes.isEmpty()) {
            return selectedGroup.nodes();
        }
        ImmutableList<Node> groupNodes = selectedGroup.nodes();
        HashSet<Integer> wanted = new HashSet<Integer>();
        int max = groupNodes.size();
        for (NodeSelection node : this.nodes) {
            wanted.addAll(node.matches(max));
        }
        ArrayList<Node> ret = new ArrayList<Node>();
        Iterator iterator = wanted.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            ret.add((Node)groupNodes.get(idx));
        }
        return ret;
    }

    private boolean isEmpty() {
        return this.nodes.isEmpty() && this.group == null;
    }

    private Group selectGroup(SearchCluster cluster) {
        if (this.group != null) {
            Optional<Group> specificGroup = cluster.group(this.group);
            if (specificGroup.isPresent()) {
                return specificGroup.get();
            }
            throw new InvalidSearchPathException("Invalid searchPath, cluster does not have " + (this.group + 1) + " groups");
        }
        ImmutableCollection groups = cluster.groups().values();
        for (Group g : groups) {
            if (!g.hasSufficientCoverage()) continue;
            return g;
        }
        return (Group)groups.iterator().next();
    }

    private static SearchPath parseElement(String element) {
        Pair<String, String> nodesAndGroup = SearchPath.halveAt('/', element);
        List<NodeSelection> nodes = SearchPath.parseNodes((String)nodesAndGroup.getFirst());
        Integer group = SearchPath.parseGroup((String)nodesAndGroup.getSecond());
        return new SearchPath(nodes, group);
    }

    private static List<NodeSelection> parseNodes(String nodes) {
        ArrayList<NodeSelection> ret = new ArrayList<NodeSelection>();
        while (nodes.length() > 0) {
            if (nodes.startsWith("[")) {
                nodes = SearchPath.parseNodeRange(nodes, ret);
                continue;
            }
            if (SearchPath.isWildcard(nodes)) {
                return Collections.emptyList();
            }
            nodes = SearchPath.parseNodeNum(nodes, ret);
        }
        return ret;
    }

    private static boolean isWildcard(String node) {
        return NODE_WILDCARD.matcher(node).lookingAt();
    }

    private static String parseNodeRange(String nodes, List<NodeSelection> into) {
        Matcher m = NODE_RANGE.matcher(nodes);
        if (m.find()) {
            String ret = nodes.substring(m.end());
            Integer start = Integer.parseInt(m.group(1));
            Integer end = Integer.parseInt(m.group(2));
            if (start > end) {
                throw new InvalidSearchPathException("Invalid range");
            }
            into.add(new NodeSelection(start, end));
            return ret;
        }
        throw new InvalidSearchPathException("Invalid range expression");
    }

    private static String parseNodeNum(String nodes, List<NodeSelection> into) {
        Pair<String, String> numAndRest = SearchPath.halveAt(',', nodes);
        int nodeNum = Integer.parseInt((String)numAndRest.getFirst());
        into.add(new NodeSelection(nodeNum, nodeNum + 1));
        return (String)numAndRest.getSecond();
    }

    private static Integer parseGroup(String group) {
        if (group.isEmpty()) {
            return null;
        }
        if ("/".equals(group) || "*".equals(group)) {
            return null;
        }
        return Integer.parseInt(group);
    }

    private static Pair<String, String> halveAt(char divider, String string) {
        int pos = string.indexOf(divider);
        if (pos >= 0) {
            return new Pair((Object)string.substring(0, pos), (Object)string.substring(pos + 1));
        }
        return new Pair((Object)string, (Object)"");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (NodeSelection p : this.nodes) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(p.toString());
        }
        if (this.group != null) {
            sb.append('/').append(this.group);
        }
        return sb.toString();
    }

    public static class InvalidSearchPathException
    extends RuntimeException {
        public InvalidSearchPathException(String message) {
            super(message);
        }

        public InvalidSearchPathException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class NodeSelection {
        private final int from;
        private final int to;

        NodeSelection(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public Collection<Integer> matches(int max) {
            if (this.from >= max) {
                return Collections.emptyList();
            }
            int end = this.to > max ? max : this.to;
            return IntStream.range(this.from, end).boxed().collect(Collectors.toList());
        }

        public String toString() {
            if (this.from + 1 == this.to) {
                return Integer.toString(this.from);
            }
            return "[" + this.from + "," + this.to + ">";
        }
    }
}

