/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.searcher;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PredicateQueryItem;
import com.yahoo.prelude.query.ToolBox;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import java.util.Optional;

@After(value={"predicate"})
public class ValidatePredicateSearcher
extends Searcher {
    @Override
    public Result search(Query query, Execution execution) {
        Optional<ErrorMessage> e = this.validate(query, execution.context().getIndexFacts().newSession(query));
        if (e.isPresent()) {
            Result r = new Result(query);
            r.hits().addError(e.get());
            return r;
        }
        return execution.search(query);
    }

    private Optional<ErrorMessage> validate(Query query, IndexFacts.Session indexFacts) {
        ValidatePredicateVisitor visitor = new ValidatePredicateVisitor(indexFacts);
        ToolBox.visit(visitor, query.getModel().getQueryTree().getRoot());
        return visitor.errorMessage;
    }

    private static class ValidatePredicateVisitor
    extends ToolBox.QueryVisitor {
        private final IndexFacts.Session indexFacts;
        public Optional<ErrorMessage> errorMessage = Optional.empty();

        public ValidatePredicateVisitor(IndexFacts.Session indexFacts) {
            this.indexFacts = indexFacts;
        }

        @Override
        public boolean visit(Item item) {
            if (item instanceof PredicateQueryItem) {
                this.visit((PredicateQueryItem)item);
            }
            return true;
        }

        private void visit(PredicateQueryItem item) {
            Index index = this.getIndexFromUnionOfDocumentTypes(item);
            for (PredicateQueryItem.RangeEntry entry : item.getRangeFeatures()) {
                long value = entry.getValue();
                if (value >= index.getPredicateLowerBound() && value <= index.getPredicateUpperBound()) continue;
                this.errorMessage = Optional.of(ErrorMessage.createIllegalQuery(String.format("%s=%d outside configured predicate bounds.", entry.getKey(), value)));
            }
        }

        private Index getIndexFromUnionOfDocumentTypes(PredicateQueryItem item) {
            return this.indexFacts.getIndex(item.getIndexName());
        }

        @Override
        public void onExit() {
        }
    }
}

