/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.yahoo.data.access.Inspector;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class DocsumDefinition {
    private final String name;
    private final ImmutableList<DocsumField> fields;
    private final boolean dynamic;
    private final ImmutableMap<String, Integer> fieldNameToIndex;

    public DocsumDefinition(String name, List<DocsumField> fields) {
        this.name = name;
        this.dynamic = false;
        this.fields = ImmutableList.copyOf(fields);
        ImmutableMap.Builder fieldNameToIndexBuilder = new ImmutableMap.Builder();
        int i = 0;
        for (DocsumField field : fields) {
            fieldNameToIndexBuilder.put((Object)field.name, (Object)i++);
        }
        this.fieldNameToIndex = fieldNameToIndexBuilder.build();
    }

    DocsumDefinition(DocumentdbInfoConfig.Documentdb.Summaryclass config) {
        this.name = config.name();
        ArrayList<DocsumField> fieldsBuilder = new ArrayList<DocsumField>();
        HashMap<String, Integer> fieldNameToIndexBuilder = new HashMap<String, Integer>();
        boolean dynamic = false;
        for (DocumentdbInfoConfig.Documentdb.Summaryclass.Fields field : config.fields()) {
            fieldNameToIndexBuilder.put(field.name(), fieldsBuilder.size());
            fieldsBuilder.add(DocsumField.create(field.name(), field.type()));
            if (!field.dynamic()) continue;
            dynamic = true;
        }
        this.dynamic = dynamic;
        this.fields = ImmutableList.copyOf(fieldsBuilder);
        this.fieldNameToIndex = ImmutableMap.copyOf(fieldNameToIndexBuilder);
    }

    public DocsumField getField(int fieldIndex) {
        if (fieldIndex >= this.fields.size()) {
            return null;
        }
        return (DocsumField)this.fields.get(fieldIndex);
    }

    public DocsumField getField(String fieldName) {
        Integer index = (Integer)this.fieldNameToIndex.get((Object)fieldName);
        if (index == null) {
            return null;
        }
        return this.getField(index);
    }

    public Object convert(String fieldName, Inspector value) {
        DocsumField fieldType = this.getField(fieldName);
        if (fieldType == null || !value.valid()) {
            return null;
        }
        return fieldType.convert(value);
    }

    public Set<String> fieldNames() {
        return this.fieldNameToIndex.keySet();
    }

    public String toString() {
        return "docsum definition '" + this.getName() + "'";
    }

    public String getName() {
        return this.name;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public List<DocsumField> getFields() {
        return this.fields;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }
}

