/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.rendering;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.processing.rendering.Renderer;
import com.yahoo.search.Result;
import com.yahoo.search.pagetemplates.result.PageTemplatesXmlRenderer;
import com.yahoo.search.rendering.JsonRenderer;
import com.yahoo.search.rendering.XmlRenderer;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;

public final class RendererRegistry
extends ComponentRegistry<Renderer<Result>> {
    public static final ComponentId xmlRendererId = ComponentId.fromString((String)"XmlRenderer");
    public static final ComponentId pageRendererId = ComponentId.fromString((String)"PageTemplatesXmlRenderer");
    public static final ComponentId jsonRendererId;
    public static final ComponentId defaultRendererId;

    public RendererRegistry() {
        this(Collections.emptyList());
    }

    public RendererRegistry(Executor executor) {
        this(Collections.emptyList(), executor);
    }

    public RendererRegistry(Collection<Renderer> renderers) {
        this(renderers, null);
    }

    public RendererRegistry(Collection<Renderer> renderers, Executor executor) {
        JsonRenderer jsonRenderer = new JsonRenderer(executor);
        jsonRenderer.initId(jsonRendererId);
        this.register(jsonRenderer.getId(), (Object)jsonRenderer);
        XmlRenderer xmlRenderer = new XmlRenderer(executor);
        xmlRenderer.initId(xmlRendererId);
        this.register(xmlRenderer.getId(), (Object)xmlRenderer);
        PageTemplatesXmlRenderer pageRenderer = new PageTemplatesXmlRenderer(executor);
        pageRenderer.initId(pageRendererId);
        this.register(pageRenderer.getId(), (Object)pageRenderer);
        for (Renderer renderer : renderers) {
            this.register(renderer.getId(), renderer);
        }
        this.freeze();
    }

    public void deconstruct() {
        this.getRenderer(jsonRendererId.toSpecification()).deconstruct();
        this.getRenderer(xmlRendererId.toSpecification()).deconstruct();
        this.getRenderer(pageRendererId.toSpecification()).deconstruct();
    }

    public Renderer<Result> getDefaultRenderer() {
        return (Renderer)this.getComponent(jsonRendererId);
    }

    public Renderer<Result> getRenderer(ComponentSpecification format) {
        if (format == null || format.stringValue().equals("default")) {
            return this.getDefaultRenderer();
        }
        if (format.stringValue().equals("json")) {
            return (Renderer)this.getComponent(jsonRendererId);
        }
        if (format.stringValue().equals("xml")) {
            return (Renderer)this.getComponent(xmlRendererId);
        }
        if (format.stringValue().equals("page")) {
            return (Renderer)this.getComponent(pageRendererId);
        }
        Renderer renderer = (Renderer)this.getComponent(format);
        if (renderer == null) {
            throw new IllegalArgumentException("No renderer with id or alias '" + format + "'. Available renderers are: [" + this.rendererNames() + "].");
        }
        return renderer;
    }

    private String rendererNames() {
        StringBuilder r = new StringBuilder();
        for (Renderer c : this.allComponents()) {
            if (r.length() > 0) {
                r.append(", ");
            }
            r.append(c.getId().stringValue());
        }
        return r.toString();
    }

    static {
        defaultRendererId = jsonRendererId = ComponentId.fromString((String)"JsonRenderer");
    }
}

