/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.rendering;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.yahoo.io.ByteWriter;
import com.yahoo.processing.Request;
import com.yahoo.processing.execution.Execution;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public abstract class Renderer
extends com.yahoo.processing.rendering.Renderer<Result> {
    public final ListenableFuture<Boolean> render(OutputStream stream, Result response, Execution execution, Request request) {
        Writer writer = null;
        try {
            writer = this.createWriter(stream, response);
            this.render(writer, response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        SettableFuture completed = SettableFuture.create();
        completed.set((Object)true);
        return completed;
    }

    protected abstract void render(Writer var1, Result var2) throws IOException;

    private Writer createWriter(OutputStream stream, Result result) {
        Charset cs = Charset.forName(this.getCharacterEncoding(result));
        CharsetEncoder encoder = cs.newEncoder();
        return new ByteWriter(stream, encoder);
    }

    public String getCharacterEncoding(Result result) {
        String encoding = result.getQuery().getModel().getEncoding();
        return encoding != null ? encoding : this.getEncoding();
    }

    public String getDefaultSummaryClass() {
        return null;
    }

    public final String getRequestedEncoding(Query query) {
        String encoding = query.getModel().getEncoding();
        if (encoding != null) {
            return encoding;
        }
        return this.getEncoding();
    }

    public Renderer clone() {
        return (Renderer)super.clone();
    }
}

