/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.ranking;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.ranking.RankProperties;
import java.util.Objects;

public class SoftTimeout
implements Cloneable {
    private static final QueryProfileType argumentType;
    public static final String ENABLE = "enable";
    public static final String FACTOR = "factor";
    public static final String TAILCOST = "tailcost";
    public static final CompoundName enableProperty;
    private Boolean enabled = null;
    private Double factor = null;
    private Double tailcost = null;

    public static QueryProfileType getArgumentType() {
        return argumentType;
    }

    public void setEnable(boolean enable) {
        this.enabled = enable;
    }

    public Boolean getEnable() {
        if (this.enabled == null) {
            return Boolean.TRUE;
        }
        return this.enabled;
    }

    public void setFactor(double factor) {
        if (factor < 0.0 || factor > 1.0) {
            throw new IllegalArgumentException("factor must be in the range [0.0, 1.0], got " + factor);
        }
        this.factor = factor;
    }

    public Double getFactor() {
        return this.factor;
    }

    public void setTailcost(double tailcost) {
        if (tailcost < 0.0 || tailcost > 1.0) {
            throw new IllegalArgumentException("tailcost must be in the range [0.0, 1.0], got " + tailcost);
        }
        this.tailcost = tailcost;
    }

    public Double getTailcost() {
        return this.tailcost;
    }

    public void prepare(RankProperties rankProperties) {
        if (this.enabled != null) {
            rankProperties.put("vespa.softtimeout.enable", String.valueOf(this.enabled));
        }
        if (this.factor != null) {
            rankProperties.put("vespa.softtimeout.factor", String.valueOf(this.factor));
        }
        if (this.tailcost != null) {
            rankProperties.put("vespa.softtimeout.tailcost", String.valueOf(this.tailcost));
        }
    }

    public SoftTimeout clone() {
        try {
            return (SoftTimeout)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Won't happen", e);
        }
    }

    public int hashCode() {
        int hash = 0;
        if (this.enabled != null) {
            hash += 11;
        }
        if (this.factor != null) {
            hash += 13 * this.factor.hashCode();
        }
        if (this.tailcost != null) {
            hash += 17 * this.tailcost.hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SoftTimeout)) {
            return false;
        }
        SoftTimeout other = (SoftTimeout)o;
        if (!Objects.equals(this.enabled, other.enabled)) {
            return false;
        }
        if (!Objects.equals(this.factor, other.factor)) {
            return false;
        }
        return Objects.equals(this.tailcost, other.tailcost);
    }

    static {
        enableProperty = CompoundName.fromComponents((String[])new String[]{"ranking", "softtimeout", ENABLE});
        argumentType = new QueryProfileType("softtimeout");
        argumentType.setStrict(true);
        argumentType.setBuiltin(true);
        argumentType.addField(new FieldDescription(ENABLE, "boolean"));
        argumentType.addField(new FieldDescription(FACTOR, "double"));
        argumentType.addField(new FieldDescription(TAILCOST, "double"));
        argumentType.freeze();
    }
}

