/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.DimensionValues;
import com.yahoo.search.query.profile.PrefixQueryProfileVisitor;
import com.yahoo.search.query.profile.QueryProfile;
import java.util.HashSet;
import java.util.Set;

final class AllUnoverridableQueryProfileVisitor
extends PrefixQueryProfileVisitor {
    private Set<CompoundName> unoverridables = new HashSet<CompoundName>();

    public AllUnoverridableQueryProfileVisitor(CompoundName prefix) {
        super(prefix);
    }

    @Override
    public void onValue(String name, Object value, DimensionBinding binding, QueryProfile owner, DimensionValues variant) {
        this.addUnoverridable(name, this.currentPrefix.append(name), binding, owner);
    }

    @Override
    public void onQueryProfileInsidePrefix(QueryProfile profile, DimensionBinding binding, QueryProfile owner, DimensionValues variant) {
        this.addUnoverridable(this.currentPrefix.last(), this.currentPrefix, binding, owner);
    }

    private void addUnoverridable(String localName, CompoundName fullName, DimensionBinding binding, QueryProfile owner) {
        if (owner == null) {
            return;
        }
        Boolean isOverridable = owner.isLocalOverridable(localName, binding);
        if (isOverridable != null && !isOverridable.booleanValue()) {
            this.unoverridables.add(fullName);
        }
    }

    public Set<CompoundName> getResult() {
        return this.unoverridables;
    }

    @Override
    public boolean isDone() {
        return false;
    }
}

