/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.grouping.GroupingRequest;
import com.yahoo.search.query.SelectParser;
import com.yahoo.search.query.parser.ParserEnvironment;
import com.yahoo.search.query.parser.ParserFactory;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.yql.VespaGroupingStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Select
implements Cloneable {
    private static final QueryProfileType argumentType = new QueryProfileType("select");
    private static final CompoundName argumentTypeName;
    public static final String SELECT = "select";
    public static final String WHERE = "where";
    public static final String GROUPING = "grouping";
    private final Query parent;
    private final List<GroupingRequest> groupingRequests;
    private String where;
    private String grouping;
    private String groupingExpressionString;

    public static QueryProfileType getArgumentType() {
        return argumentType;
    }

    public Select(Query query) {
        this("", "", query);
    }

    public Select(String where, String grouping, Query query) {
        this(where, grouping, query, Collections.emptyList());
    }

    private Select(String where, String grouping, Query query, List<GroupingRequest> groupingRequests) {
        this.where = Objects.requireNonNull(where, "A Select must have a where string (possibly the empty string)");
        this.grouping = Objects.requireNonNull(grouping, "A Select must have a select string (possibly the empty string)");
        this.parent = Objects.requireNonNull(query, "A Select must have a parent query");
        this.groupingRequests = Select.deepCopy(groupingRequests, this);
    }

    private static List<GroupingRequest> deepCopy(List<GroupingRequest> groupingRequests, Select parentOfCopy) {
        ArrayList<GroupingRequest> copy = new ArrayList<GroupingRequest>(groupingRequests.size());
        for (GroupingRequest request : groupingRequests) {
            copy.add(request.copy(parentOfCopy));
        }
        return copy;
    }

    public void setWhereString(String where) {
        this.where = where;
        this.parent.getModel().setType(SELECT);
        this.parent.getModel().clearQueryTree();
    }

    public String getWhereString() {
        return this.where;
    }

    public void setGroupingString(String grouping) {
        this.groupingRequests.clear();
        this.grouping = grouping;
        SelectParser parser = (SelectParser)ParserFactory.newInstance(Query.Type.SELECT, new ParserEnvironment());
        for (VespaGroupingStep step : parser.getGroupingSteps(grouping)) {
            GroupingRequest.newInstance(this.parent).setRootOperation(step.getOperation()).continuations().addAll(step.continuations());
        }
    }

    public void setGroupingExpressionString(String groupingExpressionString) {
        this.groupingExpressionString = groupingExpressionString;
    }

    public String getGroupingExpressionString() {
        return this.groupingExpressionString;
    }

    public String getGroupingString() {
        return this.grouping;
    }

    public List<GroupingRequest> getGrouping() {
        return this.groupingRequests;
    }

    public String toString() {
        return "where: [" + this.where + "], grouping: [" + this.grouping + "]";
    }

    public Object clone() {
        return new Select(this.where, this.grouping, this.parent, this.groupingRequests);
    }

    public Select cloneFor(Query parent) {
        return new Select(this.where, this.grouping, parent, this.groupingRequests);
    }

    static {
        argumentType.setStrict(true);
        argumentType.setBuiltin(true);
        argumentType.addField(new FieldDescription(WHERE, "string"));
        argumentType.addField(new FieldDescription(GROUPING, "string"));
        argumentType.freeze();
        argumentTypeName = new CompoundName(argumentType.getId().getName());
    }
}

