/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.log.LogLevel;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.grouping.GroupingRequest;
import com.yahoo.search.grouping.request.AllOperation;
import com.yahoo.search.grouping.request.AttributeValue;
import com.yahoo.search.grouping.request.CountAggregator;
import com.yahoo.search.grouping.request.EachOperation;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.grouping.request.GroupingOperation;
import com.yahoo.search.grouping.request.MaxAggregator;
import com.yahoo.search.grouping.request.MinAggregator;
import com.yahoo.search.grouping.request.NegFunction;
import com.yahoo.search.grouping.request.SummaryValue;
import com.yahoo.search.grouping.result.Group;
import com.yahoo.search.grouping.result.GroupList;
import com.yahoo.search.grouping.result.RootGroup;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitOrderer;
import com.yahoo.search.searchchain.Execution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

@After(value={"rawQuery"})
@Before(value={"transformedQuery"})
public class UniqueGroupingSearcher
extends Searcher {
    public static final CompoundName PARAM_UNIQUE = new CompoundName("unique");
    private static final Logger log = Logger.getLogger(UniqueGroupingSearcher.class.getName());
    private static final HitOrderer NOP_ORDERER = new HitOrderer(){

        @Override
        public void order(List<Hit> hits) {
        }
    };
    static final String LABEL_COUNT = "uniqueCount";
    static final String LABEL_GROUPS = "uniqueGroups";
    static final String LABEL_HITS = "uniqueHits";

    @Override
    public Result search(Query query, Execution execution) {
        String unique = query.properties().getString(PARAM_UNIQUE);
        if (unique == null || unique.trim().isEmpty()) {
            return execution.search(query);
        }
        query.trace("Performing deduping by attribute '" + unique + "'.", true, 3);
        return UniqueGroupingSearcher.dedupe(query, execution, unique);
    }

    private static Result dedupe(Query query, Execution execution, String dedupField) {
        Sorting sorting = query.getRanking().getSorting();
        if (sorting != null && sorting.fieldOrders().size() > 1) {
            query.trace("Can not use grouping for deduping with multi-level sorting.", 3);
            return execution.search(query);
        }
        int hits = query.getHits();
        int offset = query.getOffset();
        int groupingHits = hits + offset;
        GroupingRequest groupingRequest = GroupingRequest.newInstance(query);
        groupingRequest.setRootOperation(UniqueGroupingSearcher.buildGroupingExpression(dedupField, groupingHits, query.getPresentation().getSummary(), sorting));
        query.setHits(0);
        query.setOffset(0);
        Result result = execution.search(query);
        query = result.getQuery();
        query.setHits(hits);
        query.setOffset(offset);
        RootGroup root = groupingRequest.getResultGroup(result);
        if (null == root) {
            String msg = "Result group not found for deduping grouping request, returning empty result.";
            query.trace(msg, 3);
            log.log(LogLevel.WARNING, msg);
            throw new IllegalStateException("Failed to produce deduped result set.");
        }
        result.hits().remove(root.getId().toString());
        GroupList resultGroups = root.getGroupList(dedupField);
        if (resultGroups == null) {
            query.trace("Deduping grouping request returned no hits, returning empty result.", 3);
            return result;
        }
        result.hits().setOrderer(NOP_ORDERER);
        result.hits().addAll(UniqueGroupingSearcher.getRequestedHits(resultGroups, offset, hits));
        Long countField = (Long)root.getField(LABEL_COUNT);
        long count = countField != null ? countField : 0L;
        result.setTotalHitCount(count);
        return result;
    }

    private static List<GroupingExpression> createHitOrderingClause(Sorting sortingSpec) {
        ArrayList<GroupingExpression> orderingClause = new ArrayList<GroupingExpression>();
        block4: for (Sorting.FieldOrder fieldOrder : sortingSpec.fieldOrders()) {
            Sorting.Order sortOrder = fieldOrder.getSortOrder();
            switch (sortOrder) {
                case ASCENDING: 
                case UNDEFINED: {
                    orderingClause.add(new MinAggregator(new AttributeValue(fieldOrder.getFieldName())));
                    continue block4;
                }
                case DESCENDING: {
                    orderingClause.add(new NegFunction(new MaxAggregator(new AttributeValue(fieldOrder.getFieldName()))));
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Can not handle sort order " + sortOrder + ".");
        }
        return orderingClause;
    }

    private static GroupingExpression createGroupOrderingClause(Sorting sortingSpec) {
        GroupingExpression groupingClause = null;
        block4: for (Sorting.FieldOrder fieldOrder : sortingSpec.fieldOrders()) {
            Sorting.Order sortOrder = fieldOrder.getSortOrder();
            switch (sortOrder) {
                case ASCENDING: 
                case UNDEFINED: {
                    groupingClause = new AttributeValue(fieldOrder.getFieldName());
                    continue block4;
                }
                case DESCENDING: {
                    groupingClause = new NegFunction(new AttributeValue(fieldOrder.getFieldName()));
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Can not handle sort order " + sortOrder + ".");
        }
        return groupingClause;
    }

    private static List<Hit> getRequestedHits(GroupList resultGroups, int offset, int hits) {
        List<Hit> receivedHits = UniqueGroupingSearcher.getAllHitsFromGroupingResult(resultGroups);
        if (receivedHits.size() <= offset) {
            return Collections.emptyList();
        }
        int lastRequestedHit = Math.min(offset + hits, receivedHits.size());
        return receivedHits.subList(offset, lastRequestedHit);
    }

    private static List<Hit> getAllHitsFromGroupingResult(GroupList resultGroups) {
        ArrayList<Hit> hits = new ArrayList<Hit>(resultGroups.size());
        for (Hit groupHit : resultGroups) {
            Group group = (Group)groupHit;
            GroupList sorted = group.getGroupList(LABEL_GROUPS);
            if (sorted != null) {
                group = (Group)sorted.iterator().next();
            }
            for (Hit hit : group.getHitList(LABEL_HITS)) {
                hits.add(hit);
            }
        }
        return hits;
    }

    static GroupingOperation buildGroupingExpression(String dedupField, int groupingHits, String summaryClass, Sorting sortSpec) {
        if (sortSpec != null) {
            return UniqueGroupingSearcher.buildGroupingExpressionWithSorting(dedupField, groupingHits, summaryClass, sortSpec);
        }
        return UniqueGroupingSearcher.buildGroupingExpressionWithRanking(dedupField, groupingHits, summaryClass);
    }

    private static GroupingOperation buildGroupingExpressionWithRanking(String dedupField, int groupingHits, String summaryClass) {
        return new AllOperation().setGroupBy(new AttributeValue(dedupField)).addOutput(new CountAggregator().setLabel(LABEL_COUNT)).setMax(groupingHits).addChild(new EachOperation().setMax(1).addChild(new EachOperation().setLabel(LABEL_HITS).addOutput(summaryClass == null ? new SummaryValue() : new SummaryValue(summaryClass))));
    }

    private static GroupingOperation buildGroupingExpressionWithSorting(String dedupField, int groupingHits, String summaryClass, Sorting sortSpec) {
        return new AllOperation().setGroupBy(new AttributeValue(dedupField)).addOutput(new CountAggregator().setLabel(LABEL_COUNT)).setMax(groupingHits).addOrderBy(UniqueGroupingSearcher.createHitOrderingClause(sortSpec)).addChild(new EachOperation().addChild(new AllOperation().setGroupBy(UniqueGroupingSearcher.createGroupOrderingClause(sortSpec)).addOrderBy(UniqueGroupingSearcher.createHitOrderingClause(sortSpec)).setMax(1).addChild(new EachOperation().setLabel(LABEL_GROUPS).addChild(new EachOperation().setLabel(LABEL_HITS).addOutput(summaryClass == null ? new SummaryValue() : new SummaryValue(summaryClass))))));
    }
}

