/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.searchcluster;

import com.google.common.collect.ImmutableList;
import com.yahoo.search.dispatch.searchcluster.Node;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class Group {
    private final int id;
    private final ImmutableList<Node> nodes;
    private final AtomicBoolean hasSufficientCoverage = new AtomicBoolean(true);
    private final AtomicBoolean hasFullCoverage = new AtomicBoolean(true);
    private final AtomicLong activeDocuments = new AtomicLong(0L);

    public Group(int id, List<Node> nodes) {
        this.id = id;
        this.nodes = ImmutableList.copyOf(nodes);
        int idx = 0;
        for (Node node : nodes) {
            node.setPathIndex(idx);
            ++idx;
        }
    }

    public int id() {
        return this.id;
    }

    public ImmutableList<Node> nodes() {
        return this.nodes;
    }

    public boolean hasSufficientCoverage() {
        return this.hasSufficientCoverage.get();
    }

    void setHasSufficientCoverage(boolean sufficientCoverage) {
        this.hasSufficientCoverage.lazySet(sufficientCoverage);
    }

    public int workingNodes() {
        int nodesUp = 0;
        for (Node node : this.nodes) {
            if (node.isWorking() != Boolean.TRUE) continue;
            ++nodesUp;
        }
        return nodesUp;
    }

    void aggregateActiveDocuments() {
        long activeDocumentsInGroup = 0L;
        for (Node node : this.nodes) {
            if (node.isWorking() != Boolean.TRUE) continue;
            activeDocumentsInGroup += node.getActiveDocuments();
        }
        this.activeDocuments.set(activeDocumentsInGroup);
    }

    long getActiveDocuments() {
        return this.activeDocuments.get();
    }

    public boolean isFullCoverageStatusChanged(boolean hasFullCoverageNow) {
        boolean previousState = this.hasFullCoverage.getAndSet(hasFullCoverageNow);
        return previousState != hasFullCoverageNow;
    }

    public String toString() {
        return "search group " + this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Group)) {
            return false;
        }
        return ((Group)other).id == this.id;
    }
}

