/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.rpc;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.google.protobuf.ByteString;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class MapConverter {
    public static void convertMapTensors(Map<String, Object> map, Consumer<SearchProtocol.TensorProperty.Builder> inserter) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Tensor)) continue;
            byte[] tensor = TypedBinaryFormat.encode((Tensor)((Tensor)value));
            inserter.accept(SearchProtocol.TensorProperty.newBuilder().setName(entry.getKey()).setValue(ByteString.copyFrom((byte[])tensor)));
        }
    }

    public static void convertMapPrimitives(Map<String, Object> map, Consumer<SearchProtocol.StringProperty.Builder> inserter) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Tensor) continue;
            inserter.accept(SearchProtocol.StringProperty.newBuilder().setName(entry.getKey()).addValues(value.toString()));
        }
    }

    public static void convertStringMultiMap(Map<String, List<String>> map, Consumer<SearchProtocol.StringProperty.Builder> inserter) {
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            List<String> values = entry.getValue();
            if (values == null) continue;
            inserter.accept(SearchProtocol.StringProperty.newBuilder().setName(entry.getKey()).addAllValues(values));
        }
    }

    public static void convertMultiMap(Map<String, List<Object>> map, Consumer<SearchProtocol.StringProperty.Builder> stringInserter, Consumer<SearchProtocol.TensorProperty.Builder> tensorInserter) {
        for (Map.Entry<String, List<Object>> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            String key = entry.getKey();
            LinkedList<String> stringValues = new LinkedList<String>();
            for (Object value : entry.getValue()) {
                if (value == null) continue;
                if (value instanceof Tensor) {
                    byte[] tensor = TypedBinaryFormat.encode((Tensor)((Tensor)value));
                    tensorInserter.accept(SearchProtocol.TensorProperty.newBuilder().setName(key).setValue(ByteString.copyFrom((byte[])tensor)));
                    continue;
                }
                stringValues.add(value.toString());
            }
            if (stringValues.isEmpty()) continue;
            stringInserter.accept(SearchProtocol.StringProperty.newBuilder().setName(key).addAllValues(stringValues));
        }
    }
}

