/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.search.dispatch.searchcluster.Group;
import com.yahoo.search.dispatch.searchcluster.SearchCluster;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;

public class LoadBalancer {
    private static final Logger log = Logger.getLogger(LoadBalancer.class.getName());
    private static final long DEFAULT_LATENCY_DECAY_RATE = 1000L;
    private static final long MIN_LATENCY_DECAY_RATE = 42L;
    private static final double INITIAL_QUERY_TIME = 0.001;
    private static final double MIN_QUERY_TIME = 0.001;
    private final List<GroupStatus> scoreboard;
    private final GroupScheduler scheduler;

    public LoadBalancer(SearchCluster searchCluster, boolean roundRobin) {
        this.scoreboard = new ArrayList<GroupStatus>(searchCluster.groups().size());
        for (Group group : searchCluster.orderedGroups()) {
            this.scoreboard.add(new GroupStatus(group));
        }
        this.scheduler = roundRobin || this.scoreboard.size() == 1 ? new RoundRobinScheduler(this.scoreboard) : new AdaptiveScheduler(new Random(), this.scoreboard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Group> takeGroup(Set<Integer> rejectedGroups) {
        LoadBalancer loadBalancer = this;
        synchronized (loadBalancer) {
            Optional<GroupStatus> best = this.scheduler.takeNextGroup(rejectedGroups);
            if (best.isPresent()) {
                GroupStatus gs = best.get();
                gs.allocate();
                Group ret = gs.group;
                log.fine(() -> "Offering <" + ret + "> for query connection");
                return Optional.of(ret);
            }
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseGroup(Group group, boolean success, double searchTimeMs) {
        LoadBalancer loadBalancer = this;
        synchronized (loadBalancer) {
            for (GroupStatus sched : this.scoreboard) {
                if (sched.group.id() != group.id()) continue;
                sched.release(success, searchTimeMs / 1000.0);
                break;
            }
        }
    }

    static class AdaptiveScheduler
    implements GroupScheduler {
        private final Random random;
        private final List<GroupStatus> scoreboard;

        public AdaptiveScheduler(Random random, List<GroupStatus> scoreboard) {
            this.random = random;
            this.scoreboard = scoreboard;
        }

        private Optional<GroupStatus> selectGroup(double needle, boolean requireCoverage, Set<Integer> rejected) {
            double sum = 0.0;
            int n = 0;
            for (GroupStatus gs : this.scoreboard) {
                if (rejected != null && rejected.contains(gs.group.id()) || requireCoverage && !gs.group.hasSufficientCoverage()) continue;
                sum += gs.averageSearchTimeInverse();
                ++n;
            }
            if (n == 0) {
                return Optional.empty();
            }
            double accum = 0.0;
            for (GroupStatus gs : this.scoreboard) {
                if (rejected != null && rejected.contains(gs.group.id()) || requireCoverage && !gs.group.hasSufficientCoverage() || !(needle < (accum += gs.averageSearchTimeInverse()) / sum)) continue;
                return Optional.of(gs);
            }
            return Optional.empty();
        }

        @Override
        public Optional<GroupStatus> takeNextGroup(Set<Integer> rejectedGroups) {
            double needle = this.random.nextDouble();
            Optional<GroupStatus> gs = this.selectGroup(needle, true, rejectedGroups);
            if (gs.isPresent()) {
                return gs;
            }
            return this.selectGroup(needle, false, rejectedGroups);
        }
    }

    private static class RoundRobinScheduler
    implements GroupScheduler {
        private int needle = 0;
        private final List<GroupStatus> scoreboard;

        public RoundRobinScheduler(List<GroupStatus> scoreboard) {
            this.scoreboard = scoreboard;
        }

        @Override
        public Optional<GroupStatus> takeNextGroup(Set<Integer> rejectedGroups) {
            GroupStatus bestCandidate = null;
            int bestIndex = this.needle;
            int index = this.needle;
            for (int i = 0; i < this.scoreboard.size(); ++i) {
                GroupStatus better;
                GroupStatus candidate = this.scoreboard.get(index);
                if (!(rejectedGroups != null && rejectedGroups.contains(candidate.group.id()) || (better = RoundRobinScheduler.betterGroup(bestCandidate, candidate)) != candidate)) {
                    bestCandidate = candidate;
                    bestIndex = index;
                }
                index = this.nextScoreboardIndex(index);
            }
            this.needle = this.nextScoreboardIndex(bestIndex);
            return Optional.ofNullable(bestCandidate);
        }

        private static GroupStatus betterGroup(GroupStatus first, GroupStatus second) {
            if (second == null) {
                return first;
            }
            if (first == null) {
                return second;
            }
            if (first.group.hasSufficientCoverage() != second.group.hasSufficientCoverage()) {
                if (!first.group.hasSufficientCoverage()) {
                    return second;
                }
                return first;
            }
            return first;
        }

        private int nextScoreboardIndex(int current) {
            int next = current + 1;
            if (next >= this.scoreboard.size()) {
                next %= this.scoreboard.size();
            }
            return next;
        }
    }

    private static interface GroupScheduler {
        public Optional<GroupStatus> takeNextGroup(Set<Integer> var1);
    }

    static class GroupStatus {
        private final Group group;
        private int allocations = 0;
        private long queries = 0L;
        private double averageSearchTime = 0.001;

        GroupStatus(Group group) {
            this.group = group;
        }

        void allocate() {
            ++this.allocations;
        }

        void release(boolean success, double searchTime) {
            --this.allocations;
            if (this.allocations < 0) {
                log.warning("Double free of query target group detected");
                this.allocations = 0;
            }
            if (success) {
                searchTime = Math.max(searchTime, 0.001);
                double decayRate = Math.min(this.queries + 42L, 1000L);
                this.averageSearchTime = (searchTime + (decayRate - 1.0) * this.averageSearchTime) / decayRate;
                ++this.queries;
            }
        }

        double averageSearchTime() {
            return this.averageSearchTime;
        }

        double averageSearchTimeInverse() {
            return 1.0 / this.averageSearchTime;
        }

        int groupId() {
            return this.group.id();
        }

        void setQueryStatistics(long queries, double averageSearchTime) {
            this.queries = queries;
            this.averageSearchTime = averageSearchTime;
        }
    }
}

