/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.LeanHit;
import com.yahoo.search.query.Sorting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InvokerResult {
    private final Result result;
    private final List<LeanHit> leanHits;

    public InvokerResult(Result result) {
        this.result = result;
        this.leanHits = Collections.emptyList();
    }

    public InvokerResult(Query query, int expectedHits) {
        this.result = new Result(query);
        this.leanHits = new ArrayList<LeanHit>(expectedHits);
    }

    public Result getResult() {
        return this.result;
    }

    public List<LeanHit> getLeanHits() {
        return this.leanHits;
    }

    void complete() {
        Query query = this.result.getQuery();
        Sorting sorting = query.getRanking().getSorting();
        for (LeanHit hit : this.leanHits) {
            FastHit fh = new FastHit(hit.getGid(), hit.getRelevance(), hit.getPartId(), hit.getDistributionKey());
            if (hit.hasSortData()) {
                fh.setSortData(hit.getSortData(), sorting);
            }
            fh.setQuery(query);
            fh.setFillable();
            fh.setCached(false);
            this.result.hits().add(fh);
        }
        this.leanHits.clear();
    }
}

