/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.semantics.engine.NameSpace;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.Condition;

public class TermCondition
extends Condition {
    private String term;
    private String termPlusS;

    public TermCondition() {
    }

    public TermCondition(String term) {
        this(null, term);
    }

    public TermCondition(String label, String term) {
        super(label);
        this.term = term;
        this.termPlusS = term + "s";
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
        this.termPlusS = term + "s";
    }

    @Override
    protected boolean doesMatch(RuleEvaluation e) {
        boolean matches;
        if (this.getNameSpace() != null) {
            NameSpace nameSpace = e.getEvaluation().getNameSpace(this.getNameSpace());
            return nameSpace.matches(this.term, e);
        }
        if (e.currentItem() == null) {
            return false;
        }
        if (!this.labelMatches(e)) {
            return false;
        }
        String matchedValue = this.termMatches(e.currentItem().getItem(), e.getEvaluation().getStemming());
        boolean bl = matches = matchedValue != null && this.labelMatches(e.currentItem().getItem(), e);
        if (matches && !e.isInNegation() || !matches && e.isInNegation()) {
            e.addMatch(e.currentItem(), matchedValue);
            e.setValue(this.term);
            e.next();
        }
        return matches;
    }

    private String termMatches(TermItem queryTerm, boolean stemming) {
        String queryTermString = queryTerm.stringValue();
        boolean matches = queryTermString.equals(this.term);
        if (matches) {
            return this.term;
        }
        if (stemming && this.termMatchesWithStemming(queryTermString)) {
            return this.term;
        }
        return null;
    }

    private boolean termMatchesWithStemming(String queryTermString) {
        if (queryTermString.length() < 3) {
            return false;
        }
        boolean matches = queryTermString.equals(this.termPlusS);
        if (matches) {
            return true;
        }
        matches = this.term.equals(queryTermString + "s");
        return matches;
    }

    @Override
    public String toInnerString() {
        return this.getLabelString() + this.term;
    }
}

