/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.querytransform.PhraseMatcher;
import com.yahoo.prelude.semantics.RuleBase;
import com.yahoo.prelude.semantics.RuleBaseException;
import com.yahoo.prelude.semantics.engine.Choicepoint;
import com.yahoo.prelude.semantics.engine.EvaluationException;
import com.yahoo.prelude.semantics.engine.FlattenedItem;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.Condition;
import com.yahoo.prelude.semantics.rule.NamedCondition;
import com.yahoo.protect.Validator;

public class ConditionReference
extends Condition {
    private String conditionName;
    private NamedCondition namedCondition;
    private boolean automataLookup = false;

    public ConditionReference(String conditionName) {
        this(null, conditionName);
    }

    public ConditionReference(String label, String conditionName) {
        super(label);
        Validator.ensureNotNull((String)"Name of referenced condition", (Object)conditionName);
        this.conditionName = conditionName;
        this.setContextName(conditionName);
    }

    public String getConditionName() {
        return this.conditionName;
    }

    public void setConditionName(String name) {
        this.conditionName = name;
    }

    @Override
    public boolean doesMatch(RuleEvaluation e) {
        if (this.automataLookup) {
            return this.automataMatch(e);
        }
        if (this.namedCondition == null) {
            throw new EvaluationException("Condition reference '" + this.conditionName + "' not found or not initialized");
        }
        return this.namedCondition.matches(e);
    }

    private boolean automataMatch(RuleEvaluation e) {
        FlattenedItem current = e.currentItem();
        if (current == null) {
            return false;
        }
        Object annotation = current.getItem().getAnnotation(this.conditionName);
        if (annotation == null) {
            return false;
        }
        if (!(annotation instanceof PhraseMatcher.Phrase)) {
            return false;
        }
        PhraseMatcher.Phrase phrase = (PhraseMatcher.Phrase)annotation;
        Choicepoint choicePoint = e.getChoicepoint(this, true);
        boolean matches = this.automataMatchPhrase(phrase, e);
        if (!matches && e.isInNegation()) {
            e.addMatch(current, null);
        }
        if (!matches && !e.isInNegation() || matches && e.isInNegation()) {
            choicePoint.backtrackPosition();
        }
        return matches;
    }

    private boolean automataMatchPhrase(PhraseMatcher.Phrase phrase, RuleEvaluation e) {
        PhraseMatcher.Phrase.MatchIterator i = phrase.itemIterator();
        while (i.hasNext()) {
            i.next();
            FlattenedItem current = e.currentItem();
            if (current == null) {
                return false;
            }
            if (!this.labelMatches(e.currentItem().getItem(), e)) {
                return false;
            }
            if (!e.isInNegation()) {
                e.addMatch(current, i.getReplace());
            }
            e.next();
        }
        return phrase.getLength() <= phrase.getBackedLength();
    }

    @Override
    public void makeReferences(RuleBase ruleBase) {
        this.namedCondition = ruleBase.getCondition(this.conditionName);
        if (this.namedCondition == null) {
            if (ruleBase.usesAutomata()) {
                this.automataLookup = true;
            } else {
                throw new RuleBaseException("Referenced condition '" + this.conditionName + "' does not exist in " + ruleBase);
            }
        }
    }

    @Override
    protected boolean hasOpenChoicepoint(RuleEvaluation e) {
        if (this.namedCondition == null) {
            return false;
        }
        return this.namedCondition.getCondition().hasOpenChoicepoint(e);
    }

    @Override
    protected boolean isDefaultContextName() {
        return this.getContextName() == null || this.getContextName().equals(this.conditionName);
    }

    @Override
    protected String toInnerString() {
        return "[" + this.conditionName + "]";
    }
}

