/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.engine;

import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.prelude.semantics.engine.FlattenedItem;

public class Match {
    private int position;
    private TermItem item;
    private String replaceValue;
    private CompositeItem parent = null;

    public Match(FlattenedItem item, String replaceValue) {
        this.item = item.getItem();
        this.replaceValue = replaceValue == null ? item.getItem().getIndexedString() : replaceValue;
        this.parent = this.item.getParent();
        this.position = item.getPosition();
    }

    public int getPosition() {
        return this.position;
    }

    public TermItem getItem() {
        return this.item;
    }

    public String getReplaceValue() {
        return this.replaceValue;
    }

    public CompositeItem getParent() {
        return this.parent;
    }

    public int hashCode() {
        return 17 * this.item.getIndexedString().hashCode() + 33 * this.item.getIndexName().hashCode();
    }

    public Item toItem(String label) {
        return new WordItem(this.getReplaceValue(), label);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Match)) {
            return false;
        }
        Match other = (Match)o;
        if (other.position != this.position) {
            return false;
        }
        return other.item.equals(this.item);
    }
}

