/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query.parser;

import com.yahoo.language.Language;
import com.yahoo.language.process.Segmenter;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.AndSegmentItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.PhraseSegmentItem;
import com.yahoo.prelude.query.SegmentItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.prelude.query.parser.AnyParser;
import com.yahoo.prelude.query.parser.CustomParser;
import com.yahoo.prelude.query.parser.Token;
import com.yahoo.prelude.query.parser.TokenPosition;
import com.yahoo.prelude.query.parser.Tokenizer;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.query.parser.Parsable;
import com.yahoo.search.query.parser.ParserEnvironment;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractParser
implements CustomParser {
    protected Submodes submodes = new Submodes();
    protected Language language = Language.UNKNOWN;
    protected IndexFacts.Session indexFacts;
    protected int braceLevelURL = 0;
    protected final ParserEnvironment environment;
    protected final TokenPosition tokens = new TokenPosition();

    protected AbstractParser(ParserEnvironment environment) {
        this.environment = ParserEnvironment.fromParserEnvironment(environment);
        if (this.environment.getIndexFacts() == null) {
            this.environment.setIndexFacts(new IndexFacts());
        }
    }

    @Override
    public final QueryTree parse(Parsable query) {
        Item root = null;
        if (query != null) {
            root = this.parse(query.getQuery(), query.getFilter(), query.getExplicitLanguage().orElse(query.getLanguage()), this.environment.getIndexFacts().newSession(query.getSources(), query.getRestrict()), query.getDefaultIndexName(), query);
        }
        if (root == null) {
            root = new NullItem();
        }
        return new QueryTree(root);
    }

    @Override
    public final Item parse(String queryToParse, String filterToParse, Language parsingLanguage, IndexFacts.Session indexFacts, String defaultIndexName) {
        return this.parse(queryToParse, filterToParse, parsingLanguage, indexFacts, defaultIndexName, null);
    }

    private Item parse(String queryToParse, String filterToParse, Language parsingLanguage, IndexFacts.Session indexFacts, String defaultIndexName, Parsable parsable) {
        if (queryToParse == null) {
            return null;
        }
        this.tokenize(queryToParse, defaultIndexName, indexFacts, parsingLanguage);
        if (parsingLanguage == null && parsable != null) {
            String detectionText = this.generateLanguageDetectionTextFrom(this.tokens, indexFacts, defaultIndexName);
            if (detectionText.isEmpty()) {
                detectionText = queryToParse;
            }
            parsingLanguage = parsable.getOrDetectLanguage(detectionText);
        }
        this.setState(parsingLanguage, indexFacts);
        Item root = this.parseItems();
        if (filterToParse != null) {
            AnyParser filterParser = new AnyParser(this.environment);
            root = root == null ? filterParser.parseFilter(filterToParse, parsingLanguage, indexFacts) : filterParser.applyFilter(root, filterToParse, parsingLanguage, indexFacts);
        }
        root = AbstractParser.simplifyPhrases(root);
        if (defaultIndexName != null) {
            AbstractParser.assignDefaultIndex(indexFacts.getCanonicName(defaultIndexName), root);
        }
        return root;
    }

    private String generateLanguageDetectionTextFrom(TokenPosition tokens, IndexFacts.Session indexFacts, String defaultIndex) {
        StringBuilder detectionText = new StringBuilder();
        int initialPosition = tokens.getPosition();
        while (tokens.hasNext()) {
            Index index;
            Object queryText;
            while (!tokens.currentIs(Token.Kind.WORD) && tokens.hasNext()) {
                tokens.next();
            }
            if (!tokens.hasNext()) break;
            Token word1 = tokens.next();
            if (this.is(Token.Kind.COLON, tokens.currentNoIgnore())) {
                tokens.next();
                Token word2 = tokens.next();
                queryText = this.is(Token.Kind.WORD, word2) ? word2.image : "";
                index = indexFacts.getIndex(word1.image);
                if (index.isNull()) {
                    index = indexFacts.getIndex(defaultIndex);
                    queryText = word1.image + " " + (String)queryText;
                }
            } else if (this.is(Token.Kind.COLON, tokens.currentNoIgnore()) && this.is(Token.Kind.QUOTE, tokens.currentNoIgnore(1))) {
                tokens.next();
                tokens.next();
                StringBuilder quotedContent = new StringBuilder();
                while (!tokens.currentIs(Token.Kind.QUOTE) && tokens.hasNext()) {
                    Token token = tokens.next();
                    if (!this.is(Token.Kind.WORD, token)) continue;
                    quotedContent.append(token.image).append(" ");
                }
                tokens.next();
                queryText = quotedContent.toString();
                index = indexFacts.getIndex(word1.image);
                if (index.isNull()) {
                    index = indexFacts.getIndex(defaultIndex);
                    queryText = word1.image + " " + (String)queryText;
                }
            } else {
                index = indexFacts.getIndex(defaultIndex);
                queryText = word1.image;
            }
            if (queryText == null || !index.hasPlainTokens()) continue;
            detectionText.append((String)queryText).append(" ");
        }
        tokens.setPosition(initialPosition);
        return detectionText.toString();
    }

    private boolean is(Token.Kind kind, Token tokenOrNull) {
        if (tokenOrNull == null) {
            return false;
        }
        return kind.equals((Object)tokenOrNull.kind);
    }

    protected abstract Item parseItems();

    private static void assignDefaultIndex(String defaultIndex, Item item) {
        if (defaultIndex == null || item == null) {
            return;
        }
        if (item instanceof IndexedItem) {
            IndexedItem indexName = (IndexedItem)((Object)item);
            if ("".equals(indexName.getIndexName())) {
                indexName.setIndexName(defaultIndex);
            }
        } else if (item instanceof CompositeItem) {
            ListIterator<Item> items = ((CompositeItem)item).getItemIterator();
            while (items.hasNext()) {
                AbstractParser.assignDefaultIndex(defaultIndex, (Item)items.next());
            }
        }
    }

    protected String normalize(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        return this.environment.getLinguistics().getNormalizer().normalize(input);
    }

    protected void setState(Language queryLanguage, IndexFacts.Session indexFacts) {
        this.indexFacts = indexFacts;
        this.language = queryLanguage;
        this.submodes.reset();
    }

    protected void tokenize(String query, String defaultIndexName, IndexFacts.Session indexFacts, Language language) {
        Tokenizer tokenizer = new Tokenizer(this.environment.getLinguistics());
        tokenizer.setSubstringSpecialTokens(language != null && language.isCjk());
        tokenizer.setSpecialTokens(this.environment.getSpecialTokens());
        this.tokens.initialize(tokenizer.tokenize(query, defaultIndexName, indexFacts));
    }

    public static Item simplifyPhrases(Item unwashed) {
        if (unwashed == null) {
            return unwashed;
        }
        if (unwashed instanceof PhraseItem) {
            return AbstractParser.collapsePhrase((PhraseItem)unwashed);
        }
        if (unwashed instanceof CompositeItem) {
            CompositeItem composite = (CompositeItem)unwashed;
            ListIterator<Item> i = composite.getItemIterator();
            while (i.hasNext()) {
                Item transformed;
                Item original = i.next();
                if (original == (transformed = AbstractParser.simplifyPhrases(original))) continue;
                i.set(transformed);
            }
            return unwashed;
        }
        return unwashed;
    }

    private static Item collapsePhrase(PhraseItem phrase) {
        if (phrase.getItemCount() == 1 && phrase.getItem(0) instanceof WordItem) {
            WordItem word = (WordItem)phrase.getItem(0);
            word.setWeight(phrase.getWeight());
            return word;
        }
        return phrase;
    }

    protected Item segment(String indexName, Token token) {
        String normalizedToken = this.normalize(token.toString());
        if (token.isSpecial()) {
            WordItem w = new WordItem(token.toString(), true, token.substring);
            w.setWords(false);
            w.setFromSpecialToken(true);
            return w;
        }
        if (this.language == Language.UNKNOWN) {
            return new WordItem(normalizedToken, true, token.substring);
        }
        Segmenter segmenter = this.environment.getLinguistics().getSegmenter();
        List segments = segmenter.segment(normalizedToken, this.language);
        if (segments.size() == 0) {
            return null;
        }
        if (segments.size() == 1) {
            return new WordItem((String)segments.get(0), "", true, token.substring);
        }
        SegmentItem composite = this.indexFacts.getIndex(indexName).getPhraseSegmenting() ? new PhraseSegmentItem(token.toString(), normalizedToken, true, false, token.substring) : new AndSegmentItem(token.toString(), true, false);
        int n = 0;
        WordItem previous = null;
        for (String segment : segments) {
            WordItem w = new WordItem(segment, "", true, token.substring);
            w.setFromSegmented(true);
            w.setSegmentIndex(n++);
            w.setStemmed(false);
            if (previous != null) {
                previous.setConnectivity(w, 1.0);
            }
            previous = w;
            ((CompositeItem)composite).addItem(w);
        }
        ((CompositeItem)composite).lock();
        return composite;
    }

    final class Submodes {
        public boolean url = false;
        public boolean site = false;

        Submodes() {
        }

        public void setFromIndex(String indexName, IndexFacts.Session session) {
            if (indexName == null) {
                return;
            }
            this.reset();
            Index current = session.getIndex(indexName);
            if (current.isUriIndex()) {
                this.url = true;
            } else if (current.isHostIndex()) {
                this.site = true;
            }
        }

        public void reset() {
            this.url = false;
            this.site = false;
        }

        public boolean explicitAnchoring() {
            return this.site;
        }
    }
}

