/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.protect.Validator;
import java.util.List;
import java.util.ListIterator;

public class NotItem
extends CompositeItem {
    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.NOT;
    }

    @Override
    public String getName() {
        return "NOT";
    }

    @Override
    public void addItem(Item item) {
        super.addItem(item);
    }

    public void addNegativeItem(Item negative) {
        if (this.getItemCount() == 0) {
            this.insertNullFirstItem();
        }
        this.addItem(negative);
    }

    public List<Item> negativeItems() {
        return this.items().subList(1, this.getItemCount());
    }

    public Item getPositiveItem() {
        if (this.getItemCount() == 0) {
            return null;
        }
        return this.getItem(0);
    }

    public Item setPositiveItem(Item item) {
        Validator.ensureNotNull((String)("Positive item of " + this), (Object)item);
        if (this.getItemCount() == 0) {
            this.addItem(item);
            return null;
        }
        return this.setItem(0, item);
    }

    public void addPositiveItem(Item item) {
        if (this.getPositiveItem() == null) {
            this.setPositiveItem(item);
        } else if (this.getPositiveItem() instanceof AndItem) {
            ((AndItem)this.getPositiveItem()).addItem(item);
        } else {
            AndItem positives = new AndItem();
            positives.addItem(this.getPositiveItem());
            positives.addItem(item);
            this.setPositiveItem(positives);
        }
    }

    @Override
    public boolean removeItem(Item item) {
        int removedIndex = this.getItemIndex(item);
        boolean removed = super.removeItem(item);
        if (removed && removedIndex == 0) {
            this.insertNullFirstItem();
        }
        return removed;
    }

    @Override
    public Item removeItem(int index) {
        Item removed = super.removeItem(index);
        if (index == 0) {
            this.insertNullFirstItem();
        }
        return removed;
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        boolean isFirstItem = true;
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            if (isFirstItem) {
                buffer.append("+");
            } else {
                buffer.append(" -");
            }
            if (item == null) {
                buffer.append("(null)");
            } else {
                buffer.append(item.toString());
            }
            isFirstItem = false;
        }
    }

    @Override
    public int getTermCount() {
        Item positive = this.getPositiveItem();
        return positive == null ? 0 : positive.getTermCount();
    }
}

