/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.result.HitOrderer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SortDataHitSorter {
    public static void sort(HitGroup hitGroup, List<Hit> hits) {
        Sorting sorting = hitGroup.getQuery().getRanking().getSorting();
        HitOrderer fallbackOrderer = hitGroup.getOrderer();
        if (sorting == null || fallbackOrderer == null) {
            return;
        }
        Comparator<Hit> fallbackComparator = fallbackOrderer.getComparator();
        Collections.sort(hits, SortDataHitSorter.getComparator(sorting, fallbackComparator));
    }

    public static boolean isSortable(Hit hit, Sorting sorting) {
        if (sorting == null) {
            return false;
        }
        if (hit instanceof FastHit) {
            FastHit fhit = (FastHit)hit;
            return fhit.hasSortData(sorting);
        }
        return false;
    }

    public static Comparator<Hit> getComparator(Sorting sorting, Comparator<Hit> fallback) {
        if (fallback == null) {
            return (left, right) -> SortDataHitSorter.compareTwo(left, right, sorting);
        }
        return (left, right) -> SortDataHitSorter.compareWithFallback(left, right, sorting, fallback);
    }

    private static int compareTwo(Hit left, Hit right, Sorting sorting) {
        if (left == null || right == null || !(left instanceof FastHit) || !(right instanceof FastHit)) {
            return 0;
        }
        FastHit fl = (FastHit)left;
        FastHit fr = (FastHit)right;
        return FastHit.compareSortData(fl, fr, sorting);
    }

    private static int compareWithFallback(Hit left, Hit right, Sorting sorting, Comparator<Hit> fallback) {
        if (left == null || right == null || !(left instanceof FastHit) || !(right instanceof FastHit)) {
            return fallback.compare(left, right);
        }
        FastHit fl = (FastHit)left;
        FastHit fr = (FastHit)right;
        if (fl.hasSortData(sorting) && fr.hasSortData(sorting)) {
            return FastHit.compareSortData(fl, fr, sorting);
        }
        return fallback.compare(left, right);
    }
}

