/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.container.QrConfig;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FS4ResourcePool
extends AbstractComponent {
    private static final Logger logger = Logger.getLogger(FS4ResourcePool.class.getName());
    private static final AtomicInteger instanceCounter = new AtomicInteger(0);
    private final String serverId;
    private final int instanceId;
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduledExecutor;

    @Inject
    public FS4ResourcePool(QrConfig config) {
        this(config.discriminator());
    }

    public FS4ResourcePool(String serverId) {
        this.serverId = serverId;
        this.instanceId = instanceCounter.getAndIncrement();
        String name = "FS4-" + this.instanceId;
        this.executor = Executors.newCachedThreadPool(ThreadFactoryFactory.getDaemonThreadFactory((String)name));
        this.scheduledExecutor = Executors.newScheduledThreadPool(1, ThreadFactoryFactory.getDaemonThreadFactory((String)(name + ".scheduled")));
    }

    public String getServerId() {
        return this.serverId;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    public void deconstruct() {
        logger.log(Level.INFO, "Deconstructing FS4ResourcePool with id '" + this.instanceId + "'.");
        super.deconstruct();
        this.executor.shutdown();
        this.scheduledExecutor.shutdown();
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
            this.scheduledExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warning("Executors failed terminating within timeout of 10 seconds : " + e);
        }
    }
}

