/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.yahoo.data.access.Inspectable;
import com.yahoo.data.access.Inspector;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.result.ChainableComparator;
import com.yahoo.search.result.Hit;
import java.util.Comparator;

public class FieldComparator
extends ChainableComparator {
    private Sorting sorting;

    public FieldComparator(Sorting sorting) {
        this(sorting, null);
    }

    public FieldComparator(Sorting sorting, Comparator<Hit> secondaryComparator) {
        super(secondaryComparator);
        this.sorting = sorting;
    }

    public static FieldComparator create(Sorting sorting) {
        if (sorting == null) {
            return null;
        }
        return new FieldComparator(sorting);
    }

    @Override
    public int compare(Hit first, Hit second) {
        for (Sorting.FieldOrder fieldOrder : this.sorting.fieldOrders()) {
            Object b;
            String fieldName = fieldOrder.getFieldName();
            Object a = this.getField(first, fieldName);
            int x = this.compareValues(a, b = this.getField(second, fieldName), fieldOrder.getSorter());
            if (x == 0) continue;
            if (fieldOrder.getSortOrder() == Sorting.Order.DESCENDING) {
                x *= -1;
            }
            return x;
        }
        return super.compare(first, second);
    }

    private Object getSubField(Object field, String key) {
        if (field instanceof Inspectable) {
            Inspector sub;
            Inspector top = ((Inspectable)field).inspect();
            int firstDot = key.indexOf(46);
            if (firstDot > 0 && (sub = top.field(key.substring(0, firstDot))).valid()) {
                return this.getSubField(sub, key.substring(firstDot + 1));
            }
            sub = top.field(key);
            if (sub.valid()) {
                switch (sub.type()) {
                    case EMPTY: {
                        return null;
                    }
                    case BOOL: {
                        return sub.asBool() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case LONG: {
                        return new Long(sub.asLong());
                    }
                    case DOUBLE: {
                        return new Double(sub.asDouble());
                    }
                    case STRING: {
                        return sub.asString();
                    }
                }
                return sub.toString();
            }
        }
        return field;
    }

    public Object getField(Hit hit, String key) {
        if ("[relevance]".equals(key)) {
            return hit.getRelevance();
        }
        if ("[rank]".equals(key)) {
            return hit.getRelevance();
        }
        if ("[source]".equals(key)) {
            return hit.getSource();
        }
        int firstDot = key.indexOf(46);
        if (firstDot > 0 && hit.getField(key) == null) {
            String keyPrefix = key.substring(0, firstDot);
            String keySuffix = key.substring(firstDot + 1);
            Object a = hit.getField(keyPrefix);
            Object b = this.getSubField(a, keySuffix);
            return b;
        }
        return hit.getField(key);
    }

    private int compareValues(Object first, Object second, Sorting.AttributeSorter s) {
        if (first == null) {
            if (second == null) {
                return 0;
            }
            return -1;
        }
        if (second == null) {
            return 1;
        }
        if (first.getClass().isInstance(second) && first instanceof Comparable) {
            return s.compare((Comparable)first, (Comparable)second);
        }
        return s.compare((Comparable)((Object)first.toString()), (Comparable)((Object)second.toString()));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FieldComparator:");
        if (this.sorting == null) {
            b.append(" null");
        } else {
            b.append(this.sorting.toString());
        }
        return b.toString();
    }
}

