/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.querytransform;

import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.DotProductItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.WandItem;
import com.yahoo.prelude.query.WeakAndItem;
import com.yahoo.prelude.query.WeightedSetItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.querytransform.QueryTreeUtil;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.text.MapParser;
import com.yahoo.yolean.Exceptions;
import java.util.LinkedHashMap;
import java.util.Map;

public class WandSearcher
extends Searcher {
    @Override
    public Result search(Query query, Execution execution) {
        try {
            InputResolver inputs = new InputResolver(query, execution);
            if (!inputs.hasValidData()) {
                return execution.search(query);
            }
            QueryTreeUtil.andQueryItemWithRoot(query, this.createWandQueryItem(inputs));
            query.trace("WandSearcher: Added WAND operator", true, 4);
            return execution.search(query);
        }
        catch (IllegalArgumentException e) {
            return new Result(query, ErrorMessage.createInvalidQueryParameter(Exceptions.toMessageString((Throwable)e)));
        }
    }

    private Item createWandQueryItem(InputResolver inputs) {
        if (inputs.getWandType().equals((Object)WandType.VESPA)) {
            return this.populate(new WeakAndItem(inputs.getHeapSize()), inputs.getFieldName(), inputs.getTokens());
        }
        if (inputs.getWandType().equals((Object)WandType.OR)) {
            return this.populate(new OrItem(), inputs.getFieldName(), inputs.getTokens());
        }
        if (inputs.getWandType().equals((Object)WandType.PARALLEL)) {
            return this.populate(new WandItem(inputs.getFieldName(), inputs.getHeapSize()), inputs.getScoreThreshold(), inputs.getThresholdBoostFactor(), inputs.getTokens());
        }
        if (inputs.getWandType().equals((Object)WandType.DOT_PRODUCT)) {
            return this.populate(new DotProductItem(inputs.getFieldName()), inputs.getTokens());
        }
        throw new IllegalArgumentException("Unknown type '" + inputs.getWandType() + "'");
    }

    private CompositeItem populate(CompositeItem parent, String fieldName, Map<String, Integer> tokens) {
        for (Map.Entry<String, Integer> entry : tokens.entrySet()) {
            WordItem wordItem = new WordItem(entry.getKey(), fieldName);
            wordItem.setWeight(entry.getValue());
            wordItem.setStemmed(true);
            wordItem.setNormalizable(false);
            parent.addItem(wordItem);
        }
        return parent;
    }

    private WeightedSetItem populate(WeightedSetItem item, Map<String, Integer> tokens) {
        for (Map.Entry<String, Integer> entry : tokens.entrySet()) {
            item.addToken(entry.getKey(), (int)entry.getValue());
        }
        return item;
    }

    private WandItem populate(WandItem item, double scoreThreshold, double thresholdBoostFactor, Map<String, Integer> tokens) {
        this.populate(item, tokens);
        item.setScoreThreshold(scoreThreshold);
        item.setThresholdBoostFactor(thresholdBoostFactor);
        return item;
    }

    private static class IntegerMapParser
    extends MapParser<Integer> {
        private IntegerMapParser() {
        }

        protected Integer parseValue(String s) {
            return Integer.parseInt(s);
        }
    }

    private static class InputResolver {
        private static final CompoundName WAND_FIELD = new CompoundName("wand.field");
        private static final CompoundName WAND_TOKENS = new CompoundName("wand.tokens");
        private static final CompoundName WAND_HEAP_SIZE = new CompoundName("wand.heapSize");
        private static final CompoundName WAND_TYPE = new CompoundName("wand.type");
        private static final CompoundName WAND_SCORE_THRESHOLD = new CompoundName("wand.scoreThreshold");
        private static final CompoundName WAND_THRESHOLD_BOOST_FACTOR = new CompoundName("wand.thresholdBoostFactor");
        private final String fieldName;
        private final WandType wandType;
        private final Map<String, Integer> tokens;
        private final int heapSize;
        private final double scoreThreshold;
        private final double thresholdBoostFactor;

        public InputResolver(Query query, Execution execution) {
            String tokens;
            this.fieldName = query.properties().getString(WAND_FIELD);
            if (this.fieldName != null && (tokens = query.properties().getString(WAND_TOKENS)) != null) {
                this.wandType = this.resolveWandType(execution.context().getIndexFacts().newSession(query), query);
                this.tokens = new IntegerMapParser().parse(tokens, new LinkedHashMap());
                this.heapSize = this.resolveHeapSize(query);
                this.scoreThreshold = this.resolveScoreThreshold(query);
                this.thresholdBoostFactor = this.resolveThresholdBoostFactor(query);
                return;
            }
            this.wandType = null;
            this.tokens = null;
            this.heapSize = 0;
            this.scoreThreshold = 0.0;
            this.thresholdBoostFactor = 1.0;
        }

        private WandType resolveWandType(IndexFacts.Session indexFacts, Query query) {
            Index index = indexFacts.getIndex(this.fieldName);
            if (index.isNull()) {
                throw new IllegalArgumentException("Field '" + this.fieldName + "' was not found in " + indexFacts);
            }
            return WandType.create(query.properties().getString(WAND_TYPE, "vespa"));
        }

        private int resolveHeapSize(Query query) {
            String defaultHeapSize = "100";
            return Integer.valueOf(query.properties().getString(WAND_HEAP_SIZE, defaultHeapSize));
        }

        private double resolveScoreThreshold(Query query) {
            return Double.valueOf(query.properties().getString(WAND_SCORE_THRESHOLD, "0"));
        }

        private double resolveThresholdBoostFactor(Query query) {
            return Double.valueOf(query.properties().getString(WAND_THRESHOLD_BOOST_FACTOR, "1"));
        }

        public boolean hasValidData() {
            return this.tokens != null && !this.tokens.isEmpty();
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Map<String, Integer> getTokens() {
            return this.tokens;
        }

        public WandType getWandType() {
            return this.wandType;
        }

        public Integer getHeapSize() {
            return this.heapSize;
        }

        public Double getScoreThreshold() {
            return this.scoreThreshold;
        }

        public Double getThresholdBoostFactor() {
            return this.thresholdBoostFactor;
        }
    }

    private static enum WandType {
        VESPA("vespa"),
        OR("or"),
        PARALLEL("parallel"),
        DOT_PRODUCT("dotProduct");

        private final String type;

        private WandType(String type) {
            this.type = type;
        }

        public static WandType create(String type) {
            for (WandType enumType : WandType.values()) {
                if (!enumType.type.equals(type)) continue;
                return enumType;
            }
            return VESPA;
        }
    }
}

