/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.properties;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.query.Properties;
import com.yahoo.search.query.properties.CloneHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class PropertyMap
extends Properties {
    private static final CloneHelper cloneHelper = new CloneHelper();
    private Map<CompoundName, Object> properties = new LinkedHashMap<CompoundName, Object>();

    public void set(CompoundName name, Object value, Map<String, String> context) {
        if (this.shouldSet(name, value)) {
            this.properties.put(name, value);
        } else {
            super.set(name, value, context);
        }
    }

    protected boolean shouldSet(CompoundName name, Object value) {
        return true;
    }

    public Object get(CompoundName name, Map<String, String> context, com.yahoo.processing.request.Properties substitution) {
        if (!this.properties.containsKey(name)) {
            return super.get(name, context, substitution);
        }
        return this.properties.get(name);
    }

    public Map<CompoundName, Object> propertyMap() {
        return this.properties;
    }

    @Override
    public PropertyMap clone() {
        PropertyMap clone = (PropertyMap)super.clone();
        clone.properties = new HashMap<CompoundName, Object>();
        for (Map.Entry<CompoundName, Object> entry : this.properties.entrySet()) {
            Object cloneValue = cloneHelper.clone(entry.getValue());
            if (cloneValue == null) {
                cloneValue = entry.getValue();
            }
            clone.properties.put(entry.getKey(), cloneValue);
        }
        return clone;
    }

    public Map<String, Object> listProperties(CompoundName path, Map<String, String> context, com.yahoo.processing.request.Properties substitution) {
        Map map = super.listProperties(path, context, substitution);
        for (Map.Entry<CompoundName, Object> entry : this.properties.entrySet()) {
            CompoundName propertyName;
            if (!entry.getKey().hasPrefix(path) || (propertyName = entry.getKey().rest(path.size())).isEmpty()) continue;
            map.put(propertyName.toString(), entry.getValue());
        }
        return map;
    }

    public static Object clone(Object object) {
        return cloneHelper.clone(object);
    }
}

