/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.config;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.search.query.profile.DimensionValues;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.config.QueryProfilesConfig;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.FieldType;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.profile.types.QueryProfileTypeRegistry;
import com.yahoo.text.BooleanParser;
import java.util.HashSet;
import java.util.Set;

public class QueryProfileConfigurer
implements ConfigSubscriber.SingleSubscriber<QueryProfilesConfig> {
    private final ConfigSubscriber subscriber = new ConfigSubscriber();
    private volatile QueryProfileRegistry currentRegistry;

    public QueryProfileConfigurer(String configId) {
        this.subscriber.subscribe((ConfigSubscriber.SingleSubscriber)this, QueryProfilesConfig.class, configId);
    }

    public QueryProfileRegistry getCurrentRegistry() {
        return this.currentRegistry;
    }

    private void setCurrentRegistry(QueryProfileRegistry registry) {
        this.currentRegistry = registry;
    }

    public void configure(QueryProfilesConfig config) {
        QueryProfileRegistry registry = QueryProfileConfigurer.createFromConfig(config);
        this.setCurrentRegistry(registry);
    }

    public static QueryProfileRegistry createFromConfig(QueryProfilesConfig config) {
        QueryProfileRegistry registry = new QueryProfileRegistry();
        for (QueryProfilesConfig.Queryprofiletype profileTypeConfig : config.queryprofiletype()) {
            QueryProfileConfigurer.createProfileType(profileTypeConfig, registry.getTypeRegistry());
        }
        for (QueryProfilesConfig.Queryprofile profileConfig : config.queryprofile()) {
            QueryProfileConfigurer.createProfile(profileConfig, registry);
        }
        for (QueryProfilesConfig.Queryprofiletype profileTypeConfig : config.queryprofiletype()) {
            QueryProfileConfigurer.fillProfileType(profileTypeConfig, registry.getTypeRegistry());
        }
        HashSet<ComponentId> filled = new HashSet<ComponentId>();
        for (QueryProfilesConfig.Queryprofile profileConfig : config.queryprofile()) {
            QueryProfileConfigurer.fillProfile(profileConfig, config, registry, filled);
        }
        registry.freeze();
        return registry;
    }

    public void shutdown() {
        this.subscriber.close();
    }

    private static void createProfile(QueryProfilesConfig.Queryprofile config, QueryProfileRegistry registry) {
        QueryProfile profile = new QueryProfile(config.id());
        try {
            String typeId = config.type();
            if (typeId != null && !typeId.isEmpty()) {
                profile.setType(registry.getType(typeId));
            }
            if (config.dimensions().size() > 0) {
                String[] dimensions = new String[config.dimensions().size()];
                for (int i = 0; i < config.dimensions().size(); ++i) {
                    dimensions[i] = config.dimensions().get(i);
                }
                profile.setDimensions(dimensions);
            }
            registry.register(profile);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid " + profile, e);
        }
    }

    private static void createProfileType(QueryProfilesConfig.Queryprofiletype config, QueryProfileTypeRegistry registry) {
        QueryProfileType type = new QueryProfileType(config.id());
        type.setStrict(config.strict());
        type.setMatchAsPath(config.matchaspath());
        registry.register(type);
    }

    private static void fillProfile(QueryProfilesConfig.Queryprofile config, QueryProfilesConfig queryProfilesConfig, QueryProfileRegistry registry, Set<ComponentId> filled) {
        QueryProfile profile = (QueryProfile)registry.getComponent(new ComponentSpecification(config.id()).toId());
        if (filled.contains(profile.getId())) {
            return;
        }
        filled.add(profile.getId());
        try {
            for (String inheritedId : config.inherit()) {
                QueryProfile inherited = (QueryProfile)registry.getComponent(inheritedId);
                if (inherited == null) {
                    throw new IllegalArgumentException("Inherited query profile '" + inheritedId + "' in " + profile + " was not found");
                }
                QueryProfileConfigurer.fillProfile(inherited, queryProfilesConfig, registry, filled);
                profile.addInherited(inherited);
            }
            for (QueryProfilesConfig.Queryprofile.Reference referenceConfig : config.reference()) {
                QueryProfile referenced = (QueryProfile)registry.getComponent(referenceConfig.value());
                if (referenced == null) {
                    throw new IllegalArgumentException("Query profile '" + referenceConfig.value() + "' referenced as '" + referenceConfig.name() + "' in " + profile + " was not found");
                }
                profile.set(referenceConfig.name(), referenced, registry);
                if (referenceConfig.overridable() == null || referenceConfig.overridable().isEmpty()) continue;
                profile.setOverridable(referenceConfig.name(), BooleanParser.parseBoolean((String)referenceConfig.overridable()), null);
            }
            for (QueryProfilesConfig.Queryprofile.Property propertyConfig : config.property()) {
                profile.set(propertyConfig.name(), propertyConfig.value(), registry);
                if (propertyConfig.overridable() == null || propertyConfig.overridable().isEmpty()) continue;
                profile.setOverridable(propertyConfig.name(), BooleanParser.parseBoolean((String)propertyConfig.overridable()), null);
            }
            for (QueryProfilesConfig.Queryprofile.Queryprofilevariant variantConfig : config.queryprofilevariant()) {
                String[] forDimensionValueArray = new String[variantConfig.fordimensionvalues().size()];
                for (int i = 0; i < variantConfig.fordimensionvalues().size(); ++i) {
                    forDimensionValueArray[i] = variantConfig.fordimensionvalues().get(i).trim();
                    if (!"*".equals(forDimensionValueArray[i])) continue;
                    forDimensionValueArray[i] = null;
                }
                DimensionValues forDimensionValues = DimensionValues.createFrom(forDimensionValueArray);
                for (String inheritedId : variantConfig.inherit()) {
                    QueryProfile inherited = (QueryProfile)registry.getComponent(inheritedId);
                    if (inherited == null) {
                        throw new IllegalArgumentException("Inherited query profile '" + inheritedId + "' in " + profile + " for '" + forDimensionValues + "' was not found");
                    }
                    QueryProfileConfigurer.fillProfile(inherited, queryProfilesConfig, registry, filled);
                    profile.addInherited(inherited, forDimensionValues);
                }
                for (QueryProfilesConfig.Queryprofile.Queryprofilevariant.Reference referenceConfig : variantConfig.reference()) {
                    QueryProfile referenced = (QueryProfile)registry.getComponent(referenceConfig.value());
                    if (referenced == null) {
                        throw new IllegalArgumentException("Query profile '" + referenceConfig.value() + "' referenced as '" + referenceConfig.name() + "' in " + profile + " for '" + forDimensionValues + "' was not found");
                    }
                    profile.set(referenceConfig.name(), (Object)referenced, forDimensionValues, registry);
                }
                for (QueryProfilesConfig.Queryprofile.Queryprofilevariant.Property propertyConfig : variantConfig.property()) {
                    profile.set(propertyConfig.name(), (Object)propertyConfig.value(), forDimensionValues, registry);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid " + profile, e);
        }
    }

    private static void fillProfile(QueryProfile inherited, QueryProfilesConfig queryProfilesConfig, QueryProfileRegistry registry, Set<ComponentId> visited) {
        for (QueryProfilesConfig.Queryprofile inheritedConfig : queryProfilesConfig.queryprofile()) {
            if (!inherited.getId().stringValue().equals(inheritedConfig.id())) continue;
            QueryProfileConfigurer.fillProfile(inheritedConfig, queryProfilesConfig, registry, visited);
        }
    }

    private static void fillProfileType(QueryProfilesConfig.Queryprofiletype config, QueryProfileTypeRegistry registry) {
        QueryProfileType type = (QueryProfileType)((Object)registry.getComponent(new ComponentSpecification(config.id()).toId()));
        try {
            for (String inheritedId : config.inherit()) {
                QueryProfileType inherited = (QueryProfileType)((Object)registry.getComponent(inheritedId));
                if (inherited == null) {
                    throw new IllegalArgumentException("Inherited query profile type '" + inheritedId + "' in " + type + " was not found");
                }
                type.inherited().add(inherited);
            }
            for (QueryProfilesConfig.Queryprofiletype.Field fieldConfig : config.field()) {
                QueryProfileConfigurer.instantiateFieldDescription(fieldConfig, type, registry);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid " + type, e);
        }
    }

    private static void instantiateFieldDescription(QueryProfilesConfig.Queryprofiletype.Field fieldConfig, QueryProfileType type, QueryProfileTypeRegistry registry) {
        try {
            FieldType fieldType = FieldType.fromString(fieldConfig.type(), registry);
            FieldDescription field = new FieldDescription(fieldConfig.name(), fieldType, fieldConfig.alias(), fieldConfig.mandatory(), fieldConfig.overridable());
            type.addField(field, registry);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid field '" + fieldConfig.name() + "' in " + type, e);
        }
    }
}

