/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.compiled;

import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.compiled.Binding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DimensionalValue<VALUE> {
    private final List<Value<VALUE>> values;

    public DimensionalValue(Value<VALUE> value) {
        this.values = Collections.singletonList(value);
    }

    public DimensionalValue(List<Value<VALUE>> valueVariants) {
        if (valueVariants.size() == 1) {
            this.values = Collections.singletonList(valueVariants.get(0));
        } else {
            this.values = new ArrayList<Value<VALUE>>(valueVariants);
            Collections.sort(this.values);
        }
    }

    public VALUE get(Map<String, String> context) {
        if (context == null) {
            context = Collections.emptyMap();
        }
        for (Value<VALUE> value : this.values) {
            if (!value.matches(context)) continue;
            return value.value();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public String toString() {
        return this.values.toString();
    }

    private static class Value<VALUE>
    implements Comparable<Value> {
        private VALUE value = null;
        private Binding binding = null;

        public Value(VALUE value, Binding binding) {
            this.value = value;
            this.binding = binding;
        }

        public VALUE value() {
            return this.value;
        }

        public Binding binding() {
            if (this.binding == null) {
                return Binding.nullBinding;
            }
            return this.binding;
        }

        public boolean matches(Map<String, String> context) {
            return this.binding.matches(context);
        }

        @Override
        public int compareTo(Value other) {
            return this.binding.compareTo(other.binding);
        }

        public String toString() {
            return " value '" + this.value + "' for " + this.binding;
        }

        private static class Builder<VALUE> {
            private final VALUE value;
            private Set<DimensionBinding> variants = new HashSet<DimensionBinding>();

            public Builder(VALUE value) {
                this.value = value;
            }

            public void addVariant(DimensionBinding binding) {
                this.variants.add(binding);
            }

            public List<Value<VALUE>> build() {
                if (this.variants.size() == 1) {
                    return Collections.singletonList(new Value<VALUE>(this.value, Binding.createFrom(this.variants.iterator().next())));
                }
                ArrayList<Value<VALUE>> values = new ArrayList<Value<VALUE>>(this.variants.size());
                for (DimensionBinding variant : this.variants) {
                    values.add(new Value<VALUE>(this.value, Binding.createFrom(variant)));
                }
                return values;
            }

            public Object value() {
                return this.value;
            }
        }
    }

    public static class Builder<VALUE> {
        private Map<VALUE, Value.Builder<VALUE>> buildableVariants = new HashMap<VALUE, Value.Builder<VALUE>>();

        public void add(VALUE value, DimensionBinding variantBinding) {
            Value.Builder<VALUE> variant = this.buildableVariants.get(value);
            if (variant == null) {
                variant = new Value.Builder<VALUE>(value);
                this.buildableVariants.put(value, variant);
            }
            variant.addVariant(variantBinding);
        }

        public DimensionalValue<VALUE> build() {
            ArrayList variants = new ArrayList();
            for (Value.Builder<VALUE> buildableVariant : this.buildableVariants.values()) {
                variants.addAll(buildableVariant.build());
            }
            return new DimensionalValue(variants);
        }
    }
}

