/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.compiled;

import com.google.common.collect.ImmutableMap;
import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.compiled.DimensionalValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DimensionalMap<KEY, VALUE> {
    private final Map<KEY, DimensionalValue<VALUE>> values;

    private DimensionalMap(Map<KEY, DimensionalValue<VALUE>> values) {
        this.values = ImmutableMap.copyOf(values);
    }

    public VALUE get(KEY key, Map<String, String> context) {
        DimensionalValue<VALUE> variants = this.values.get(key);
        if (variants == null) {
            return null;
        }
        return variants.get(context);
    }

    public Set<Map.Entry<KEY, DimensionalValue<VALUE>>> entrySet() {
        return this.values.entrySet();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public static class Builder<KEY, VALUE> {
        private Map<KEY, DimensionalValue.Builder<VALUE>> entries = new HashMap<KEY, DimensionalValue.Builder<VALUE>>();

        public void put(KEY key, DimensionBinding binding, VALUE value) {
            DimensionalValue.Builder<VALUE> entry = this.entries.get(key);
            if (entry == null) {
                entry = new DimensionalValue.Builder();
                this.entries.put(key, entry);
            }
            entry.add(value, binding);
        }

        public DimensionalMap<KEY, VALUE> build() {
            HashMap<KEY, DimensionalValue<VALUE>> map = new HashMap<KEY, DimensionalValue<VALUE>>();
            for (Map.Entry<KEY, DimensionalValue.Builder<VALUE>> entry : this.entries.entrySet()) {
                map.put(entry.getKey(), entry.getValue().build());
            }
            return new DimensionalMap(map);
        }
    }
}

