/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileCompiler;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.profile.types.QueryProfileTypeRegistry;

public class QueryProfileRegistry
extends ComponentRegistry<QueryProfile> {
    private QueryProfileTypeRegistry queryProfileTypeRegistry = new QueryProfileTypeRegistry();

    public void register(QueryProfile profile) {
        super.register(profile.getId(), (Object)profile);
    }

    public QueryProfileType getType(String type) {
        return (QueryProfileType)((Object)this.queryProfileTypeRegistry.getComponent(type));
    }

    public QueryProfileTypeRegistry getTypeRegistry() {
        return this.queryProfileTypeRegistry;
    }

    public QueryProfile findQueryProfile(String idString) {
        if (idString == null) {
            return (QueryProfile)this.getComponent("default");
        }
        ComponentSpecification id = new ComponentSpecification(idString);
        QueryProfile profile = (QueryProfile)this.getComponent(id);
        if (profile != null) {
            return profile;
        }
        return this.findPathParentQueryProfile(new ComponentSpecification(idString));
    }

    private QueryProfile findPathParentQueryProfile(ComponentSpecification id) {
        QueryProfile slashedProfile = (QueryProfile)this.getComponent(new ComponentSpecification(id.getName() + "/", id.getVersionSpecification()));
        if (slashedProfile != null && slashedProfile.getType() != null && slashedProfile.getType().getMatchAsPath()) {
            return slashedProfile;
        }
        int slashIndex = id.getName().lastIndexOf("/");
        if (slashIndex < 1) {
            return null;
        }
        String parentName = id.getName().substring(0, slashIndex);
        if (parentName.equals("")) {
            return null;
        }
        ComponentSpecification parentId = new ComponentSpecification(parentName, id.getVersionSpecification());
        QueryProfile pathParentProfile = (QueryProfile)this.getComponent(parentId);
        if (pathParentProfile != null && pathParentProfile.getType() != null && pathParentProfile.getType().getMatchAsPath()) {
            return pathParentProfile;
        }
        return this.findPathParentQueryProfile(parentId);
    }

    public void freeze() {
        if (this.isFrozen()) {
            return;
        }
        this.queryProfileTypeRegistry.freeze();
        for (QueryProfile queryProfile : this.allComponents()) {
            queryProfile.freeze();
        }
    }

    public CompiledQueryProfileRegistry compile() {
        return QueryProfileCompiler.compile(this);
    }
}

