/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.search.Query;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.config.QueryProfileXMLReader;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.util.Map;

public class DumpTool {
    public String resolveAndDump(String ... args) {
        if (args.length == 0 || args[0].startsWith("-")) {
            StringBuilder result = new StringBuilder();
            result.append("Dumps all resolved query profile properties for a set of dimension values\n");
            result.append("USAGE: dump [query-profile] [dir]? [parameters]?\n");
            result.append("  and [query-profile] is the name of the query profile to dump the values of\n");
            result.append("  and [dir] is a path to an application package or query profile directory. Default: current dir\n");
            result.append("  and   [parameters] is the http request encoded dimension keys used during resolving. Default: none\n");
            result.append("Examples:\n");
            result.append("  dump default\n");
            result.append("  - dumps the 'default' profile non-variant values in the current dir\n");
            result.append("  dump default x=x1&y=y1\n");
            result.append("  - dumps the 'default' profile resolved with dimensions values x=x1 and y=y1 in the current dir\n");
            result.append("  dump default myapppackage\n");
            result.append("  - dumps the 'default' profile non-variant values in myapppackage/search/query-profiles\n");
            result.append("  dump default dev/myprofiles x=x1&y=y1\n");
            result.append("  - dumps the 'default' profile resolved with dimensions values x=x1 and y=y1 in dev/myprofiles\n");
            return result.toString();
        }
        if (args.length >= 3) {
            return this.dump(args[0], args[1], args[2]);
        }
        if (args.length == 2) {
            if (args[1].contains("=")) {
                return this.dump(args[0], "", args[1]);
            }
            return this.dump(args[0], args[1], "");
        }
        return this.dump(args[0], "", "");
    }

    private String dump(String profileName, String dir, String parameters) {
        File dirInAppPackage;
        if (dir.isEmpty()) {
            dir = ".";
        }
        if ((dirInAppPackage = new File(dir, "search/query-profiles")).exists()) {
            dir = dirInAppPackage.getPath();
        }
        QueryProfileXMLReader reader = new QueryProfileXMLReader();
        QueryProfileRegistry registry = reader.read(dir);
        registry.freeze();
        Query query = new Query("?" + parameters, registry.compile().findQueryProfile(profileName));
        Map properties = query.properties().listProperties();
        StringBuilder b = new StringBuilder();
        for (Map.Entry property : properties.entrySet()) {
            b.append((String)property.getKey());
            b.append("=");
            b.append(property.getValue().toString());
            b.append("\n");
        }
        return b.toString();
    }

    public static void main(String ... args) {
        try {
            System.out.print(new DumpTool().resolveAndDump(args));
        }
        catch (Exception e) {
            System.err.println(Exceptions.toMessageString((Throwable)e));
        }
    }
}

