/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query;

import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.TermItem;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class QueryTree
extends CompositeItem {
    public QueryTree(Item root) {
        this.setRoot(root);
    }

    @Override
    public void setIndexName(String index) {
        if (this.getRoot() != null) {
            this.getRoot().setIndexName(index);
        }
    }

    @Override
    public Item.ItemType getItemType() {
        throw new RuntimeException("Packet type access attempted. A query tree has no packet code. This is probably a misbehaving searcher.");
    }

    @Override
    public String getName() {
        return "ROOT";
    }

    @Override
    public int encode(ByteBuffer buffer) {
        if (this.getRoot() == null) {
            return 0;
        }
        return this.getRoot().encode(buffer);
    }

    @Override
    protected void appendHeadingString(StringBuilder sb) {
    }

    public Item getRoot() {
        if (this.getItemCount() == 0) {
            return null;
        }
        return this.getItem(0);
    }

    public final void setRoot(Item root) {
        if (root == this) {
            throw new IllegalArgumentException("Cannot make a root point at itself");
        }
        if (root == null) {
            throw new IllegalArgumentException("Root must not be null, use NullItem instead.");
        }
        if (root instanceof QueryTree) {
            throw new IllegalArgumentException("Do not use a new QueryTree instance as a root.");
        }
        if (this.getItemCount() == 0) {
            super.addItem(root);
        } else {
            this.setItem(0, root);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof QueryTree)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public QueryTree clone() {
        QueryTree clone = (QueryTree)super.clone();
        this.fixClonedConnectivityReferences(clone);
        return clone;
    }

    private void fixClonedConnectivityReferences(QueryTree clone) {
    }

    @Override
    public void addItem(Item item) {
        if (this.getItemCount() != 0) {
            throw new RuntimeException("Programming error: Cannot add multiple roots");
        }
        super.addItem(item);
    }

    @Override
    public void addItem(int index, Item item) {
        if (this.getItemCount() != 0 || index != 0) {
            throw new RuntimeException("Programming error: Cannot add multiple roots, have '" + this.getRoot() + "'");
        }
        super.addItem(index, item);
    }

    public boolean isEmpty() {
        return this.getRoot() instanceof NullItem || this.getItemCount() == 0;
    }

    private void and(Item item) {
        if (this.isEmpty()) {
            this.setRoot(item);
        } else {
            if (this.getRoot() instanceof NotItem && item instanceof NotItem) {
                throw new IllegalArgumentException("Can't AND two NOTs");
            }
            if (this.getRoot() instanceof NotItem) {
                NotItem notItem = (NotItem)this.getRoot();
                notItem.addPositiveItem(item);
            } else if (item instanceof NotItem) {
                NotItem notItem = (NotItem)item;
                notItem.addPositiveItem(this.getRoot());
                this.setRoot(notItem);
            } else {
                AndItem andItem = new AndItem();
                andItem.addItem(this.getRoot());
                andItem.addItem(item);
                this.setRoot(andItem);
            }
        }
    }

    public static List<IndexedItem> getPositiveTerms(Item item) {
        ArrayList<IndexedItem> items = new ArrayList<IndexedItem>();
        QueryTree.getPositiveTerms(item, items);
        return items;
    }

    private static void getPositiveTerms(Item item, List<IndexedItem> terms) {
        if (item instanceof NotItem) {
            QueryTree.getPositiveTerms(((NotItem)item).getPositiveItem(), terms);
        } else if (item instanceof PhraseItem) {
            PhraseItem pItem = (PhraseItem)item;
            terms.add(pItem);
        } else if (item instanceof CompositeItem) {
            ListIterator<Item> i = ((CompositeItem)item).getItemIterator();
            while (i.hasNext()) {
                QueryTree.getPositiveTerms((Item)i.next(), terms);
            }
        } else if (item instanceof TermItem) {
            terms.add((TermItem)item);
        }
    }
}

