/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query;

import com.google.common.base.Splitter;
import com.yahoo.collections.LazySet;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.prelude.query.Highlight;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.search.Query;
import com.yahoo.search.query.QueryHelper;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.rendering.RendererRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Presentation
implements Cloneable {
    private static QueryProfileType argumentType = new QueryProfileType("presentation");
    public static final String PRESENTATION = "presentation";
    public static final String BOLDING = "bolding";
    public static final String TIMING = "timing";
    public static final String SUMMARY = "summary";
    public static final String SUMMARY_FIELDS = "summaryFields";
    public static final String FORMAT = "format";
    private Highlight highlight = null;
    private List<IndexedItem> boldingData = null;
    private boolean bolding = true;
    private String summary = null;
    private ComponentSpecification format = RendererRegistry.defaultRendererId.toSpecification();
    private boolean timing = false;
    @NonNull
    private Set<String> summaryFields = LazySet.newHashSet();
    private static final Splitter COMMA_SPLITTER;

    public static QueryProfileType getArgumentType() {
        return argumentType;
    }

    public Presentation(Query parent) {
    }

    public Highlight getHighlight() {
        return this.highlight;
    }

    public void setHighlight(Highlight highlight) {
        this.highlight = highlight;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public boolean getBolding() {
        return this.bolding;
    }

    public void setBolding(boolean bolding) {
        this.bolding = bolding;
    }

    @NonNull
    public ComponentSpecification getRenderer() {
        return this.format;
    }

    public void setRenderer(@Nullable ComponentSpecification format) {
        this.format = format != null ? format : RendererRegistry.defaultRendererId.toSpecification();
    }

    @NonNull
    public String getFormat() {
        return this.format.getName();
    }

    public void setFormat(@Nullable String format) {
        this.setRenderer(ComponentSpecification.fromString((String)format));
    }

    public Object clone() {
        try {
            Presentation clone = (Presentation)super.clone();
            if (this.boldingData != null) {
                clone.boldingData = new ArrayList<IndexedItem>(this.boldingData);
            }
            if (this.highlight != null) {
                clone.highlight = this.highlight.clone();
            }
            if (this.summaryFields != null) {
                clone.summaryFields = LazySet.newHashSet();
                clone.summaryFields.addAll(this.summaryFields);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Someone inserted a noncloneable superclass", e);
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Presentation)) {
            return false;
        }
        Presentation p = (Presentation)o;
        return QueryHelper.equals(this.bolding, p.bolding) && QueryHelper.equals(this.summary, p.summary);
    }

    public int hashCode() {
        return QueryHelper.combineHash(this.bolding, this.summary);
    }

    public boolean getTiming() {
        return this.timing;
    }

    public void setTiming(boolean timing) {
        this.timing = timing;
    }

    @NonNull
    public Set<String> getSummaryFields() {
        return this.summaryFields;
    }

    public void prepare() {
        if (this.highlight != null) {
            this.highlight.prepare();
        }
    }

    public void setSummaryFields(String asString) {
        this.summaryFields.clear();
        for (String field : COMMA_SPLITTER.split((CharSequence)asString)) {
            this.summaryFields.add(field);
        }
    }

    static {
        argumentType.setStrict(true);
        argumentType.setBuiltin(true);
        argumentType.addField(new FieldDescription(BOLDING, "boolean", BOLDING));
        argumentType.addField(new FieldDescription(TIMING, "boolean", TIMING));
        argumentType.addField(new FieldDescription(SUMMARY, "string", SUMMARY));
        argumentType.addField(new FieldDescription(FORMAT, "string", "format template"));
        argumentType.addField(new FieldDescription(SUMMARY_FIELDS, "string", SUMMARY_FIELDS));
        argumentType.freeze();
        COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    }
}

