/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query;

import com.yahoo.language.Language;
import com.yahoo.language.Linguistics;
import com.yahoo.language.LocaleFactory;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TaggableItem;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.query.QueryHelper;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.query.Ranking;
import com.yahoo.search.query.parser.Parsable;
import com.yahoo.search.query.parser.Parser;
import com.yahoo.search.query.parser.ParserEnvironment;
import com.yahoo.search.query.parser.ParserFactory;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.text.Lowercase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;

public class Model
implements Cloneable {
    private static final QueryProfileType argumentType = new QueryProfileType("model");
    private static final CompoundName argumentTypeName;
    public static final String MODEL = "model";
    public static final String PROGRAM = "program";
    public static final String QUERY_STRING = "queryString";
    public static final String TYPE = "type";
    public static final String FILTER = "filter";
    public static final String DEFAULT_INDEX = "defaultIndex";
    public static final String LANGUAGE = "language";
    public static final String LOCALE = "locale";
    public static final String ENCODING = "encoding";
    public static final String SOURCES = "sources";
    public static final String SEARCH_PATH = "searchPath";
    public static final String RESTRICT = "restrict";
    public static final CompoundName ESTIMATE;
    private String encoding = null;
    private String queryString = "";
    private String filter = null;
    private Language language = null;
    private Locale locale = null;
    private QueryTree queryTree = null;
    private String defaultIndex = null;
    private Query.Type type = Query.Type.ALL;
    private Query parent;
    private Set<String> sources = new LinkedHashSet<String>();
    private Set<String> restrict = new LinkedHashSet<String>();
    private String searchPath;
    private String documentDbName = null;
    private Execution execution = new Execution(new Execution.Context(null, null, null, null, null));

    public static QueryProfileType getArgumentType() {
        return argumentType;
    }

    public Model(Query query) {
        this.setParent(query);
    }

    public Language getParsingLanguage() {
        return this.getParsingLanguage(this.queryString);
    }

    public Language getParsingLanguage(String languageDetectionText) {
        Language language = this.getLanguage();
        if (language != null) {
            return language;
        }
        language = Language.fromEncoding((String)this.encoding);
        if (language != Language.UNKNOWN) {
            return language;
        }
        if (this.queryTree != null) {
            language = this.languageBelow(this.queryTree);
        }
        if (language != Language.UNKNOWN) {
            return language;
        }
        Linguistics linguistics = this.execution.context().getLinguistics();
        if (linguistics != null) {
            language = linguistics.getDetector().detect(languageDetectionText, null).getLanguage();
        }
        if (language != Language.UNKNOWN) {
            return language;
        }
        return Language.ENGLISH;
    }

    private Language languageBelow(Item item) {
        if (item.getLanguage() != Language.UNKNOWN) {
            return item.getLanguage();
        }
        if (item instanceof CompositeItem) {
            ListIterator<Item> i = ((CompositeItem)item).getItemIterator();
            while (i.hasNext()) {
                Language childLanguage = this.languageBelow((Item)i.next());
                if (childLanguage == Language.UNKNOWN) continue;
                return childLanguage;
            }
        }
        return Language.UNKNOWN;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public void setLanguage(String language) {
        this.setLocale(language.replace("_", "-"));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setLanguage(Language.fromLocale((Locale)locale));
    }

    public void setLocale(String languageTag) {
        this.setLocale(LocaleFactory.fromLanguageTag((String)languageTag));
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = Lowercase.toLowerCase((String)encoding);
    }

    public void setSearchPath(String searchPath) {
        this.searchPath = searchPath;
    }

    public String getSearchPath() {
        return this.searchPath;
    }

    public void setQueryString(String queryString) {
        if (queryString == null) {
            queryString = "";
        }
        this.queryString = queryString;
        this.clearQueryTree();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public QueryTree getQueryTree() {
        if (this.queryTree == null) {
            Parser parser = ParserFactory.newInstance(this.type, ParserEnvironment.fromExecutionContext(this.execution.context()));
            this.queryTree = parser.parse(Parsable.fromQueryModel(this));
            if (this.parent.getTraceLevel() >= 2) {
                this.parent.trace("Query parsed to: " + this.parent.yqlRepresentation(), 2);
            }
        }
        return this.queryTree;
    }

    public void clearQueryTree() {
        this.queryTree = null;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getDefaultIndex() {
        return this.defaultIndex;
    }

    public void setDefaultIndex(String defaultIndex) {
        this.defaultIndex = defaultIndex;
    }

    public Query.Type getType() {
        return this.type;
    }

    public void setType(Query.Type type) {
        this.type = type;
    }

    public void setType(String typeString) {
        this.type = Query.Type.getType(typeString);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Model)) {
            return false;
        }
        Model other = (Model)o;
        if (!(QueryHelper.equals(other.encoding, this.encoding) && QueryHelper.equals(other.language, this.language) && QueryHelper.equals(other.searchPath, this.searchPath) && QueryHelper.equals(other.sources, this.sources) && QueryHelper.equals(other.restrict, this.restrict) && QueryHelper.equals(other.defaultIndex, this.defaultIndex) && QueryHelper.equals((Object)other.type, (Object)this.type))) {
            return false;
        }
        if (other.queryTree == null && this.queryTree == null) {
            return QueryHelper.equals(other.queryString, this.queryString) && QueryHelper.equals(other.filter, this.filter);
        }
        return QueryHelper.equals(other.getQueryTree(), this.getQueryTree());
    }

    public int hashCode() {
        return this.getClass().hashCode() + QueryHelper.combineHash(new Object[]{this.encoding, this.filter, this.language, this.getQueryTree(), this.sources, this.restrict, this.defaultIndex, this.type, this.searchPath});
    }

    public Object clone() {
        try {
            Model clone = (Model)super.clone();
            if (this.queryTree != null) {
                clone.queryTree = this.queryTree.clone();
            }
            if (this.sources != null) {
                clone.sources = new LinkedHashSet<String>(this.sources);
            }
            if (this.restrict != null) {
                clone.restrict = new LinkedHashSet<String>(this.restrict);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Someone inserted a noncloneable superclass", e);
        }
    }

    public Model cloneFor(Query q) {
        Model model = (Model)this.clone();
        model.setParent(q);
        return model;
    }

    public Query getParent() {
        return this.parent;
    }

    public void setParent(Query parent) {
        if (parent == null) {
            throw new NullPointerException("A query models owner cannot be null");
        }
        this.parent = parent;
    }

    public void setSources(String sourceString) {
        this.setFromString(sourceString, this.sources);
    }

    public Set<String> getSources() {
        return this.sources;
    }

    public void setRestrict(String restrictString) {
        this.setFromString(restrictString, this.restrict);
    }

    public Set<String> getRestrict() {
        return this.restrict;
    }

    public void setExecution(Execution execution) {
        if (execution == this.execution) {
            return;
        }
        if (execution.trace().traceNode().isRoot() && execution.trace().traceNode() != this.execution.trace().traceNode().root()) {
            this.execution.trace().traceNode().add(execution.trace().traceNode());
        }
        this.execution = execution;
    }

    public void setDocumentDb(String documentDbName) {
        this.documentDbName = documentDbName;
    }

    public String getDocumentDb() {
        return this.documentDbName;
    }

    public Execution getExecution() {
        return this.execution;
    }

    private void setFromString(String string, Set<String> set) {
        set.clear();
        for (String item : string.split(",")) {
            set.add(item.trim());
        }
    }

    public static Model getFrom(Query q) {
        return (Model)q.properties().get(argumentTypeName);
    }

    public String toString() {
        return "query representation [queryTree: " + this.queryTree + ", filter: " + this.filter + "]";
    }

    public void prepare(Ranking ranking) {
        this.prepareRankFeaturesFromModel(ranking);
    }

    private void prepareRankFeaturesFromModel(Ranking ranking) {
        Item root = this.getQueryTree().getRoot();
        if (root != null) {
            List<Item> tagged = this.setUniqueIDs(root);
            this.addLabels(tagged, ranking);
            this.addConnectivityRankProperties(tagged, ranking);
            this.addSignificances(tagged, ranking);
        }
    }

    private List<Item> setUniqueIDs(Item root) {
        ArrayList<Item> items = new ArrayList<Item>();
        this.collectTaggableItems(root, items);
        int id = 1;
        for (Item i : items) {
            TaggableItem t = (TaggableItem)((Object)i);
            t.setUniqueID(id++);
        }
        return items;
    }

    private void addLabels(List<Item> candidates, Ranking ranking) {
        for (Item candidate : candidates) {
            String label = candidate.getLabel();
            if (label == null) continue;
            String name = "vespa.label." + label + ".id";
            TaggableItem t = (TaggableItem)((Object)candidate);
            ranking.getProperties().put(name, String.valueOf(t.getUniqueID()));
        }
    }

    private void addConnectivityRankProperties(List<Item> connectedItems, Ranking ranking) {
        for (Item link : connectedItems) {
            TaggableItem t = (TaggableItem)((Object)link);
            Item connectedTo = t.getConnectedItem();
            if (connectedTo == null || !this.strictContains(connectedTo, connectedItems)) continue;
            TaggableItem t2 = (TaggableItem)((Object)connectedTo);
            String name = "vespa.term." + t.getUniqueID() + ".connexity";
            ranking.getProperties().put(name, String.valueOf(t2.getUniqueID()));
            ranking.getProperties().put(name, String.valueOf(t.getConnectivity()));
        }
    }

    private void addSignificances(List<Item> candidates, Ranking ranking) {
        for (Item candidate : candidates) {
            TaggableItem t = (TaggableItem)((Object)candidate);
            if (!t.hasExplicitSignificance()) continue;
            String name = "vespa.term." + t.getUniqueID() + ".significance";
            ranking.getProperties().put(name, String.valueOf(t.getSignificance()));
        }
    }

    private void collectTaggableItems(Item root, List<Item> terms) {
        if (root == null) {
            return;
        }
        if (root instanceof TaggableItem) {
            terms.add(root);
        } else if (root instanceof CompositeItem) {
            CompositeItem c = (CompositeItem)root;
            ListIterator<Item> i = c.getItemIterator();
            while (i.hasNext()) {
                this.collectTaggableItems((Item)i.next(), terms);
            }
        }
    }

    private boolean strictContains(Object needle, Collection<?> haystack) {
        for (Object pin : haystack) {
            if (pin != needle) continue;
            return true;
        }
        return false;
    }

    static {
        argumentType.setStrict(true);
        argumentType.setBuiltin(true);
        argumentType.addField(new FieldDescription(QUERY_STRING, "string", "query"));
        argumentType.addField(new FieldDescription(TYPE, "string", TYPE));
        argumentType.addField(new FieldDescription(FILTER, "string", FILTER));
        argumentType.addField(new FieldDescription(DEFAULT_INDEX, "string", "default-index"));
        argumentType.addField(new FieldDescription(LANGUAGE, "string", "language lang"));
        argumentType.addField(new FieldDescription(LOCALE, "string", LOCALE));
        argumentType.addField(new FieldDescription(ENCODING, "string", ENCODING));
        argumentType.addField(new FieldDescription(SOURCES, "string", "sources search"));
        argumentType.addField(new FieldDescription(SEARCH_PATH, "string", "searchpath"));
        argumentType.addField(new FieldDescription(RESTRICT, "string", RESTRICT));
        argumentType.freeze();
        argumentTypeName = new CompoundName(argumentType.getId().getName());
        ESTIMATE = new CompoundName("hitcountestimate");
    }
}

