/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates.engine;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.ComponentId;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.pagetemplates.PageTemplate;
import com.yahoo.search.pagetemplates.engine.Resolution;
import com.yahoo.search.pagetemplates.model.Choice;
import com.yahoo.search.pagetemplates.model.MapChoice;
import com.yahoo.search.pagetemplates.model.PageTemplateVisitor;

public abstract class Resolver
extends AbstractComponent {
    public Resolver(String id) {
        super(new ComponentId(id));
    }

    public Resolver(ComponentId id) {
        super(id);
    }

    protected Resolver() {
    }

    public Resolution resolve(Choice pageTemplate, Query query, Result result) {
        Resolution resolution = new Resolution();
        this.resolve(pageTemplate, query, result, resolution);
        PageTemplate chosenPageTemplate = (PageTemplate)pageTemplate.get(resolution.getResolution(pageTemplate)).get(0);
        ChoiceResolverVisitor choiceResolverVisitor = new ChoiceResolverVisitor(query, result, resolution);
        chosenPageTemplate.accept(choiceResolverVisitor);
        return choiceResolverVisitor.getResolution();
    }

    public void resolve(Choice choice, Query query, Result result, Resolution resolution) {
    }

    public void resolve(MapChoice choice, Query query, Result result, Resolution resolution) {
    }

    private class ChoiceResolverVisitor
    extends PageTemplateVisitor {
        private Resolution resolution;
        private Query query;
        private Result result;

        public ChoiceResolverVisitor(Query query, Result result, Resolution resolution) {
            this.query = query;
            this.result = result;
            this.resolution = resolution;
        }

        @Override
        public void visit(Choice choice) {
            if (choice.alternatives().size() < 2) {
                return;
            }
            Resolver.this.resolve(choice, this.query, this.result, this.resolution);
        }

        @Override
        public void visit(MapChoice choice) {
            Resolver.this.resolve(choice, this.query, this.result, this.resolution);
        }

        public Resolution getResolution() {
            return this.resolution;
        }
    }
}

