/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.vespa;

import com.yahoo.prelude.fastsearch.DocsumDefinitionSet;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.GroupingListHit;
import com.yahoo.search.Query;
import com.yahoo.search.Searcher;
import com.yahoo.search.grouping.vespa.ResultBuilder;
import com.yahoo.searchlib.aggregation.FS4Hit;
import com.yahoo.searchlib.aggregation.Hit;
import com.yahoo.searchlib.aggregation.VdsHit;

class HitConverter
implements ResultBuilder.HitConverter {
    private final Searcher searcher;
    private final Query query;

    public HitConverter(Searcher searcher, Query query) {
        this.searcher = searcher;
        this.query = query;
    }

    @Override
    public com.yahoo.search.result.Hit toSearchHit(String summaryClass, Hit hit) {
        if (hit instanceof FS4Hit) {
            return this.convertFs4Hit(summaryClass, (FS4Hit)hit);
        }
        if (hit instanceof VdsHit) {
            return this.convertVdsHit(summaryClass, (VdsHit)hit);
        }
        throw new UnsupportedOperationException("Hit type '" + hit.getClass().getName() + "' not supported.");
    }

    private com.yahoo.search.result.Hit convertFs4Hit(String summaryClass, FS4Hit groupHit) {
        FastHit hit = new FastHit();
        hit.setRelevance(groupHit.getRank());
        hit.setGlobalId(groupHit.getGlobalId());
        hit.setPartId(groupHit.getPath());
        hit.setDistributionKey(groupHit.getDistributionKey());
        hit.setFillable();
        hit.setSearcherSpecificMetaData(this.searcher, summaryClass);
        GroupingListHit hitContext = (GroupingListHit)groupHit.getContext();
        if (hitContext == null) {
            throw new NullPointerException("Hit has no context.");
        }
        hit.setSource(hitContext.getSource());
        hit.setQuery(hitContext.getQuery());
        if (hitContext.getQueryPacketData() != null) {
            hit.setQueryPacketData(hitContext.getQueryPacketData());
        }
        return hit;
    }

    private com.yahoo.search.result.Hit convertVdsHit(String summaryClass, VdsHit grpHit) {
        FastHit ret = new FastHit();
        ret.setRelevance(grpHit.getRank());
        if (grpHit.getSummary().getData().length > 0) {
            GroupingListHit ctxHit = (GroupingListHit)grpHit.getContext();
            if (ctxHit == null) {
                throw new NullPointerException("Hit has no context.");
            }
            DocsumDefinitionSet defs = ctxHit.getDocsumDefinitionSet();
            defs.lazyDecode(summaryClass, grpHit.getSummary().getData(), ret);
            ret.setFilled(summaryClass);
            ret.setFilled(this.query.getPresentation().getSummary());
        }
        return ret;
    }
}

